
{*********************************************************************}
{*                               P R I N T P                         *}
{*-------------------------------------------------------------------*}
{*    Task        : Makes a function available for sending           *}
{*                     strings to a printer and registers            *}
{*                     errors during the output to the printer       *}
{*-------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                               *}
{*    developed on   :  7/9/87                                       *}
{*    last Update    : 6/09/89                                       *}
{*********************************************************************}

program PRINTPP;

Uses Crt, Dos;                                { Add Crt and Dos units }

{$V-}                                      { Don't test string length }

type Output = string[255];

var PrintError : byte;                           { Printer error code }

{*********************************************************************}
{* PRINTCHARACTER: sends a character to the printer                  *}
{* Input : see below                                                 *}
{* Output : TRUE  if an error occurred, else FALSE                   *}
{* Info    : if an error is discovered, the status of the printer is *}
{*           stored in the global variable PRINTERROR                *}
{*********************************************************************}

function PrintCharacter(Character : char;    { Character to be output }
                      Printer : integer) : boolean;  { Nr. of Printer }

var Regs : Registers;          { Register variable for interrupt call }

begin
 Regs.ah := 0;
 Regs.al := ord(Character);     { Function number & code of character }
 Regs.dx := Printer;                                 { Printer number }
 intr($17, Regs);                       { Call BIOS printer interrupt }
 if (Regs.ah and $21) <> 0 then                 { Did an error occur? }
  begin                                                         { YES }
   PrintCharacter := false;                           { Display error }
   PrintError := Regs.ah;                         { Record error code }
  end
 else PrintCharacter := true                               { No error }
end;

{*********************************************************************}
{* PRINTSTRING: sends a string to the selected printer               *}
{* Input : see below                                                 *}
{* Output : TRUE  if no error occurred, else FALSE                   *}
{*********************************************************************}

function PrintString(Text    : Output;      { the string to be output }
                     Printer : integer) : boolean;{ Number of printer }

var Counter : integer;                                 { loop counter }
    Ok      : boolean;        { Result of the PRINTCHARACTER function }

begin
 Counter := 1;         { begin with the first character in the string }
 repeat
  Ok := PrintCharacter(Text[Counter], Printer);   { Print a character }
  Counter := succ(Counter)                   { Process next character }
 until not(Ok) or (Counter > length(Text));      { Terminate on error }
 PrintString := Ok;                      { Set result of the function }
end;

{*********************************************************************}
{* INITPRINTER: initializes the printer interface                    *}
{* Input : see below                                                 *}
{* Output : true, if no error occurred, otherwise false              *}
{* Info    : if an Error is detected, the Status of the Printer is   *}
{*           stored in the global Variable PRINTERROR                *}
{*********************************************************************}

function InitPrinter(Printer : integer) : boolean;   { Printer number }

var Regs : Registers;         { Register variables for interrupt call }

begin
 Regs.ah := $2;                            { Function number for Init }
 Regs.dx := Printer;                                 { Printer number }
 intr($17, Regs);                       { Call BIOS printer interrupt }
 if (Regs.ah and $21) <> 0 then                { Did an error occur ? }
  begin                                                         { YES }
   InitPrinter := false;                              { Display error }
   PrintError := Regs.ah;                         { Record error code }
  end
 else InitPrinter := true                                  { No error }
end;

{*********************************************************************}
{* PRINTERROR: outputs error message                                 *}
{* Input : none                                                      *}
{* Output : none                                                     *}
{* Info    : the error message is displayed according to the content *}
{*           of the variable                                         *}
{*           PRINTERROR                                              *}
{*********************************************************************}

procedure PrinterError;

begin
 write('Error during printer access: ');
 if PrintError and 1 <> 0                           { Time out error? }
  then writeln('Time-Out Error')                                { YES }
  else if PrintError and 8 <> 0                          { I/O error? }
   then writeln('I/O Error')                                    { YES }
    else if PrintError and 32 <> 0                  { No more paper ? }
     then writeln('out of paper')                               { YES }
     else writeln('Error unknown');
end;


{********************************************************************}
{*                            MAIN PROGRAM                          *}
{********************************************************************}

begin
 clrscr;                                              { Clear screen }
 writeln('PRINT (c) 1987 by Michael Tischer');
 writeln(#13#10'If a printer is interfaced to the parallel interface '+
         '0 of the PC, ');
 writeln('the following text should now appear on this '+
         'printer:');
 writeln(#13#10'a test of the printer routines...'#13#10);
 writeln('Otherwise the program will display an error message !');
 writeln;
 if InitPrinter(0) then               { Initialize printer interface 0 }
  begin
   if PrintString('a test of the printer routines...'#13#10, 0)
    then writeln('all o.k.')
    else PrinterError                          { display error message }
  end                                           { Initialization error }
 else PrinterError;                            { display error message }
end.
