{*********************************************************************}
{*                                  R T C                            *}
{*-------------------------------------------------------------------*}
{*    Task          : makes two Functions available for reading and  *}
{*                     writing data in the RTC                       *}
{*-------------------------------------------------------------------*}
{*    Author        : MICHAEL TISCHER                                *}
{*    developed on  : 7.10.87                                        *}
{*    last Update   : 9.21.87                                        *}
{*********************************************************************}

program RTCP;


Uses                                                   {Turbo 4.0 only}
  Crt;

const RTCAdrPort  = $70;                { Address-Register of the RTC }
      RTCDtaPort  = $71;                   { Data-Register of the RTC }

      SECONDS     =  0;   { Addresses of some memory locations of RTC }
      MINUTE      =  2;
      HOUR        =  4;
      DAYOFWEEK   =  6;
      DAY         =  7;
      MONTH       =  8;
      YEAR        =  9;
      STATUSA     = 10;
      STATUSB     = 11;
      STATUSC     = 12;
      STATUSD     = 13;
      DIAGNOSIS   = 14;
      YEARHUNDRED = 50;

{*********************************************************************}
{* RTCREAD: reads the content of a memory location of the RTC        *}
{* Input  : the address of the memory location in the RTC            *}
{* Output : the content of this memory location                      *}
{* Info   : if the Address is outside the permitted area             *}
{*          (0 to 63), the value -1 is returned                      *}
{*********************************************************************}

function RTCRead(Address : integer) : integer;

begin
 if (Address < 0) or (Address > 63)            { is the Address o.k.? }
  then RTCRead := -1                                            { NO! }
  else
   begin
    port[RTCAdrPort] := Address;        { transmit Address to the RTC }
    RTCRead := port[RTCDtaPort]                    { read its Content }
   end
end;

{*********************************************************************}
{* RTCDT  : read a memory location for date or time from the         *}
{*          RTC and convert the result into a binary value           *}
{*          if the RTC works in BCD-Format                           *}
{* Input  : the address of the memory location in the RTC            *}
{* Output : the content of this memory location as binary value      *}
{* Info   : if the address is outside the permitted area (0 - 63)    *}
{*          the value  -1 is returned                                *}
{*********************************************************************}

function RTCDT(Address : integer) : integer;

var Value : integer;           { for memory of a value which was read }

begin
 if (RTCRead(STATUSB) and 2 = 0)               { BCD- or Binary-Mode? }
  then RTCDT := RTCRead(Address)                     { is Binary-Mode }
  else                                                  { is BCD-Mode }
   begin
    Value := RTCRead(Address);   { get Content of the memory location }
    RTCDT := (Value shr 4) * 10 + Value and 15{ convert BCD to binary }
   end
end;

{*********************************************************************}
{* RTCWRITE: write a value into one of the memory locations of RTC   *}
{* Input   : see below                                               *}
{* Output  : none                                                    *}
{* Info    : the address can be between 0 to 63                      *}
{*********************************************************************}

procedure RTCWrite(Address : integer;   { the address of the location }
                   Content  : byte);                { the new content }

begin
 port[RTCAdrPort] := Address;           { transmit address to the RTC }
 port[RTCDtaPort] := Content                        { write new value }
end;

{*********************************************************************}
{*                            MAIN PROGRAM                           *}
{*********************************************************************}

begin
 clrscr;                                               { Clear Screen }
 writeln('RTC (c) 1987 by Michael Tischer'#13#10);
 writeln('Information from the real time clock ');
 writeln('====================================================='#13#10);
 if RTCRead(Diagnosis) and 128 = 0 then        { is the Battery o.k.? }
  begin                                         { the Battery is o.k. }
  writeln('-the clock is being operated in ', (RTCRead(STATUSB) and 2)*6+12,
           ' hour-mode');
   writeln('- the time: ', RTCDT(HOUR), ':', RTCDT(MINUTE):2,
           ':', RTCDT(SECONDS):2);
   write('- the date: ');
   case RTCDT(DAYOFWEEK) of                    { Read Day of the Week }
    1 : write('Sunday');
    2 : write('Monday');
    3 : write('Tuesday');
    4 : write('Wednesday');
    5 : write('Thursday');
    6 : write('Friday');
    7 : write('Saturday')
   end;
  writeln(', the ',RTCDT(DAY), '.', RTCDT(MONTH), '.',
          RTCDT(YEARHUNDRED), RTCDT(YEAR));
  end
 else                          { the Battery of the RTC is exhausted! }
  write('       WARNING! The Battery of the clock is low!')
end.

