 QR36WKST:
    PROC(OPPTR) OPTIONS(REENTRANT);
 
 /********************************************************************/
 /*                                                                  */
 /*    MODULE NAME: SUBR21                                           */
 /*                                                                  */
 /*    LAST MODIFICATION:  12/01/85                                  */
 /*                                                                  */
 /*    CHANGE ACTIVITY:                                              */
 /*                                                                  */
 /*               RLSE&                                              */
 /*  FLAG REASON  LEVEL  DATE   PGMR COMMENTS                        */
 /*  ---- ------- ------ ------ ---- ---------------------------     */
 /*                                                                  */
 /*    COPYRIGHT: REFER TO MODULE QWCOPYRT FOR COPYRIGHT INFORMATION.*/
 /*                                                                  */
 /*    FUNCTION: HANDLE WORKSTN ID TO DEVICE NAME CONVERSION         */
 /*                                                                  */
 /*    PARAMETERS: 1 - REQUEST                                       */
 /*                    'I' FIND WKSTN ID FOR GIVEN DEVICE NAME       */
 /*                    'D' FIND DEVICE NAME FOR WKSTN ID             */
 /*                2 - WORKSTATION ID                                */
 /*                    2 CHAR WHICH IDENTIFY THE WORKSTN             */
 /*                                                                  */
 /*                3 - RETURN CODE                                   */
 /*                    0 SUCCESSFUL                                  */
 /*                    1 FAILED - WORKSTN NOT ACTIVE                 */
 /*                    2 FAILED - NOT PLATFORM ENVIROMENT            */
 /*                             - INVALID REQUEST (NOT I OR D)       */
 /*                             - EXCEPTION                          */
 /*                4 - DEVICE NAME                                   */
 /*                                                                  */
 /*                                                                  */
 /*                                                                  */
 /********************************************************************/
 
 ?PM36;
 ?PJIB;
 ?PIWA;
 @INCLUDE INCLIB(MRTDEV);
 
 
    DCL
      E6 EXCEPTION(MIEXC,('9999'X,'CPF')); /* FUNCTION CHECK         */
 
 /*   PROGRAM DECLARES                                               */
 
    DCL
          OPPTR PTR(SPP);          /* POINTER TO REQUEST             */
 
 
    DCL 1 * BASED(OPPTR),
         2 OP CHAR(1),              /* REQUEST                       */
         2 ID CHAR(2),              /* WORKSTATION ID                */
         2 DVC CHAR(10),            /* WORKSTN DEVICE NAME           */
         2 RC CHAR(1);              /* RETURN CODE                   */
 
  DCL I FIXED(15);                  /*                           JRO */
  DCL LEN FIXED(15);               /*                           JRO */
 
 @EJECT;
 
 /*                                                                  */
 /*    START OF EXECUTABLE CODE                                      */
 /*                                                                  */
 
  IF WWCBPLT='0'B THEN              /* PLATFORM ENVIROMENT           */
   DO;                              /* NO                            */
    RC='2';                         /* INDICATE OPERATION FAILED     */
    RTX(*);                         /* GET OUT                       */
   END;
 
  MIEXESW='0';                      /* RESET THE SWITCH          JRO */
  ?PADDR;                           /*                           JRO */
  MRTDEV@ = JCBMRTC@;               /* ADDRESS MRT DEV TABLE     JRO */
 
   RC = '0';                        /* ASSUME EVERYTHING OKAY    JRO */
 
   IF OP='I' THEN                   /* GET WORKSTN ID            JRO */
    DO;                             /* YES                       JRO */
  DO I = 1 TO 100 WHILE DVC^= MRTDEVD(I); /* FIND DEVICE NAME    JRO */
  END;                              /*                           JRO */
  IF I > 100 THEN                   /* DEVICE NAME  IN TABLE     JRO */
   DO;                              /* NO  - ERROR               JRO */
    RC='1';                         /* NO MATCH ON DEVICE NAME   JRO */
    RTX(*);                         /*                           JRO */
    END;                            /*                           JRO */
   ELSE                             /*                           JRO */
    DO;                             /*                           JRO */
    ID=MRTWSID(I);                  /* SET ID OF WORKSTN         JRO */
    END;                            /*                           JRO */
   ELSE                             /*                           JRO */
    DO;                             /*                           JRO */
   IF OP='D' THEN                   /* NEED DEVICE NAME          JRO */
    DO;                             /* YES                       JRO */
  DO I = 1 TO 100 WHILE ID ^= MRTWSID(I); /* FIND TABLE ENTRY    JRO */
  END;                              /*                           JRO */
  IF I > 100 THEN                   /* WKSTN ID NOT IN TABLE     JRO */
   DO;                              /* YES - ERROR               JRO */
    RC='1';                         /* NO MATCH ON WKSTN ID      JRO */
    RTX(*);                         /*                           JRO */
   END;
   ELSE                             /*                           JRO */
    DO;                             /*                           JRO */
   DVC=MRTDEVD(I);                  /* WORKSTN DEVICE NAME       JRO */
    END;                            /*                           JRO */
    END;                            /*                           JRO */
    ELSE                            /*                           JRO */
   DO;                              /* INVALID REQUEST           JRO */
    RC '2';                         /*                           JRO */
   END;
    END;                            /*                           JRO */
    RTX(*);
 
    /*****************************************************************/
    /*                                                               */
    /* CATCH ALL EXCPTION HANDLER                                    */
    /*                                                               */
    /*****************************************************************/
 
 MIEXC:
   DCL MIEXESW CHAR(1) INIT('0');
   IF MIEXESW='1' THEN             /* ALREADY HANDLING AN EXCEPTION */
    RTX(*);                        /* YES - GET OUT                 */
 
    MIEXESW='1';                   /* HANDLING AN EXCEPTION         */
    RC = '2';                      /* SET CANCEL REPLY              */
    RTX(*);
    END QR36WKST;
