{-------------------------------------------------------------------}
{ MAKEFONT                                                          }
{ Geoffrey Silverton, 1/1993                                        }
{                                                                   }
{ This program can be used to easily change the font used by the    }
{ lowres unit.  Just edit the characters below and compile and run  }
{ with:                                                             }
{                     makefont > lowfont.inc                        }
{ at the dos prompt.                                                }
{                                                                   }
{ Remember, if you make the font larger than 6x6, you may need to   }
{ modify the code in lowres.pas slightly.                           }
{                                                                   }
{ This program was converted from C to Pascal, so it's a little     }
{ messy.                                                            }
{                                                                   }
{-------------------------------------------------------------------}

program MakeFont;

type FCHR =
  record
    size: integer;
    bmp:  array [0..7, 0..4] of char;
  end;

const FONTSIZE = 95;          { actual size minus 1 }

type FONTTYPE = array [0..FONTSIZE] of FCHR;

const Font: FONTTYPE =
  (
    (size:2; bmp:( '     ',        {  ,  }
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:1; bmp:( 'X    ',        { !,  }
                   'X    ',
                   'X    ',
                   '     ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X X  ',        { ',  }
                   'X X  ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( ' X X ',        { #  }
                   'XXXXX',
                   ' X X ',
                   'XXXXX',
                   ' X X ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( 'XXXXX',        { $  }
                   'X X  ',
                   'XXXXX',
                   '  X X',
                   'XXXXX',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( 'X   X',        { %  }
                   '   X ',
                   '  X  ',
                   ' X   ',
                   'X   X',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( ' X   ',        { &  }
                   'X X  ',
                   ' XX X',
                   'X  X ',
                   ' XX X',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( ' X   ',        { '  }
                   'X    ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( ' X   ',        { (  }
                   'X    ',
                   'X    ',
                   'X    ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( 'X    ',        { )  }
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:4; bmp:( 'X  X ',        { *  }
                   ' XX  ',
                   'XXXX ',
                   ' XX  ',
                   'X  X ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { +  }
                   ' X   ',
                   'XXX  ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( '     ',        { ,  }
                   '     ',
                   '     ',
                   '     ',
                   ' X   ',
                   'X    ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { -  }
                   '     ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:1; bmp:( '     ',        { .  }
                   '     ',
                   '     ',
                   '     ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( '    X',        { /  }
                   '   X ',
                   '  X  ',
                   ' X   ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { 0  }
                   'X X  ',
                   'X X  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XX   ',        { 1  }
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { 2  }
                   '  X  ',
                   'XXX  ',
                   'X    ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { 3  }
                   '  X  ',
                   ' XX  ',
                   '  X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X X  ',        { 4  }
                   'X X  ',
                   'XXX  ',
                   '  X  ',
                   '  X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { 5  }
                   'X    ',
                   'XXX  ',
                   '  X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { 6  }
                   'X    ',
                   'XXX  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { 7  }
                   '  X  ',
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { 8  }
                   'X X  ',
                   'XXX  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { 9  }
                   'X X  ',
                   'XXX  ',
                   '  X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:1; bmp:( '     ',        { :  }
                   'X    ',
                   '     ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( '     ',        { ;  }
                   ' X   ',
                   '     ',
                   '     ',
                   ' X   ',
                   'X    ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '  X  ',        { <  }
                   ' X   ',
                   'X    ',
                   ' X   ',
                   '  X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:4; bmp:( '     ',        { =  }
                   'XXXX ',
                   '     ',
                   'XXXX ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X    ',        { >  }
                   ' X   ',
                   '  X  ',
                   ' X   ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XX   ',        { ?  }
                   '  X  ',
                   ' X   ',
                   '     ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:4; bmp:( 'XXXX ',        { @  }
                   'X  X ',
                   'X XX ',
                   'X    ',
                   'XXXX ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { A  }
                   'X X  ',
                   'XXX  ',
                   'X X  ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XX   ',        { B  }
                   'X X  ',
                   'XX   ',
                   'X X  ',
                   'XX   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( ' XX  ',        { C  }
                   'X    ',
                   'X    ',
                   'X    ',
                   ' XX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XX   ',        { D  }
                   'X X  ',
                   'X X  ',
                   'X X  ',
                   'XX   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { E  }
                   'X    ',
                   'XX   ',
                   'X    ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { F  }
                   'X    ',
                   'XX   ',
                   'X    ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:4; bmp:( ' XX  ',        { G  }
                   'X    ',
                   'X XX ',
                   'X  X ',
                   ' XX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X X  ',        { H  }
                   'X X  ',
                   'XXX  ',
                   'X X  ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { I  }
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '  X  ',        { J  }
                   '  X  ',
                   '  X  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X X  ',        { K  }
                   'X X  ',
                   'XX   ',
                   'X X  ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X    ',        { L  }
                   'X    ',
                   'X    ',
                   'X    ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( 'X   X',        { M  }
                   'XX XX',
                   'X X X',
                   'X   X',
                   'X   X',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:4; bmp:( 'X  X ',        { N  }
                   'XX X ',
                   'X XX ',
                   'X  X ',
                   'X  X ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { O  }
                   'X X  ',
                   'X X  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { P  }
                   'X X  ',
                   'XXX  ',
                   'X    ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:4; bmp:( ' XX  ',        { Q  }
                   'X  X ',
                   'X  X ',
                   'X X  ',
                   ' X X ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XX   ',        { R  }
                   'X X  ',
                   'XX   ',
                   'X X  ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { S  }
                   'X    ',
                   'XXX  ',
                   '  X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { T  }
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X X  ',        { U  }
                   'X X  ',
                   'X X  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X X  ',        { V  }
                   'X X  ',
                   'X X  ',
                   'X X  ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( 'X   X',        { W  }
                   'X   X',
                   'X X X',
                   'XX XX',
                   'X   X',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X X  ',        { X  }
                   'X X  ',
                   ' X   ',
                   'X X  ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X X  ',        { Y  }
                   'X X  ',
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { Z  }
                   '  X  ',
                   ' X   ',
                   'X    ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { [  }
                   'X    ',
                   'X    ',
                   'X    ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( 'X    ',        { \  }
                   ' X   ',
                   '  X  ',
                   '   S ',
                   '    X',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XXX  ',        { ]  }
                   '  X  ',
                   '  X  ',
                   '  X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( ' X   ',        { ^  }
                   'X X  ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( '     ',        { _  }
                   '     ',
                   '     ',
                   '     ',
                   'XXXXX',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X    ',        { `  }
                   ' X   ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { a  }
                   'XX   ',
                   ' XX  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X    ',        { b  }
                   'XXX  ',
                   'X X  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( '     ',        { c  }
                   'XX   ',
                   'X    ',
                   'X    ',
                   'XX   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '  X  ',        { d  }
                   'XXX  ',
                   'X X  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { e  }
                   'XXX  ',
                   'X X  ',
                   'XX   ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( ' XX  ',        { f  }
                   ' X   ',
                   'XXX  ',
                   ' X   ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { g  }
                   'XXX  ',
                   'X X  ',
                   'XXX  ',
                   '  X  ',
                   'XXX  ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X    ',        { h  }
                   'X    ',
                   'XXX  ',
                   'X X  ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:1; bmp:( 'X    ',        { i  }
                   '     ',
                   'X    ',
                   'X    ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( ' X   ',        { j  }
                   '     ',
                   ' X   ',
                   ' X   ',
                   ' X   ',
                   'XX   ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'X    ',        { k  }
                   'X    ',
                   'X X  ',
                   'XX   ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:1; bmp:( 'X    ',        { l  }
                   'X    ',
                   'X    ',
                   'X    ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( '     ',        { m  }
                   'XXXXX',
                   'X X X',
                   'X X X',
                   'X X X',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { n  }
                   'XXX  ',
                   'X X  ',
                   'X X  ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { o  }
                   'XXX  ',
                   'X X  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { p  }
                   'XXX  ',
                   'X X  ',
                   'XXX  ',
                   'X    ',
                   'X    ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { q  }
                   'XXX  ',
                   'X X  ',
                   'XXX  ',
                   '  X  ',
                   '  X  ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( '     ',        { r  }
                   'XX   ',
                   'X    ',
                   'X    ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( '     ',        { s  }
                   'XX   ',
                   'X    ',
                   ' X   ',
                   'XX   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( ' X   ',        { t  }
                   ' X   ',
                   'XXX  ',
                   ' X   ',
                   ' XX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { u  }
                   'X X  ',
                   'X X  ',
                   'X X  ',
                   'XXX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { v  }
                   'X X  ',
                   'X X  ',
                   'X X  ',
                   ' X   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( '     ',        { w  }
                   'X X X',
                   'X X X',
                   'X X X',
                   'XXXXX',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { x  }
                   'X X  ',
                   ' X   ',
                   ' X   ',
                   'X X  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( '     ',        { y  }
                   'X X  ',
                   'X X  ',
                   'XXX  ',
                   '  X  ',
                   'XXX  ',
                   '     ',
                   '     ' ) ),
    (size:2; bmp:( '     ',        { z  }
                   'XX   ',
                   ' X   ',
                   'X    ',
                   'XX   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( ' XX  ',        { (  }
                   ' X   ',
                   'XX   ',
                   ' X   ',
                   ' XX  ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:1; bmp:( 'X    ',        { |  }
                   'X    ',
                   'X    ',
                   'X    ',
                   'X    ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:3; bmp:( 'XX   ',        { )  }
                   ' X   ',
                   ' XX  ',
                   ' X   ',
                   'XX   ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:4; bmp:( ' X X ',        { ~  }
                   'X X  ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ',
                   '     ' ) ),
    (size:5; bmp:( 'X X X',        {   }
                   ' X X ',
                   'X X X',
                   ' X X ',
                   'X X X',
                   '     ',
                   '     ',
                   '     ' ) )
  );

var
  c:    integer;
  x, y: integer;
  m:    array[0..4] of byte;

begin
  writeln('const lofont: array[32..127] of array[0..5] of byte = ');
  writeln('  (');

  for c:=0 to FONTSIZE do
    begin
      for x := 0 to 4 do
        begin
          m[x] := 0;
          for y := 0 to 7 do
            begin
              m[x] := m[x] shl 1;
              m[x] := m[x] or (ord(Font[c].bmp[y][x] <> ' ') and 1);
            end;
        end;
      write('  ( ', m[0]:3, ', ', m[1]:3, ', ', m[2]:3, ', ',
            m[3]:3, ', ', m[4]:3, ', ', Font[c].size:1, ' )');
      if (c <> FONTSIZE) then
        write(',')
      else
        write(' ');

      if ((c+ord(' ')) <> ord('}')) and ((c+ord(' ')) <> ord('{')) then
        writeln('     {  ', chr(c + ord(' ')), '  }')
      else
        writeln('     { ', c + ord(' '), ' }');
    end;

  writeln('  );');
end.