#define CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif
#undef	endwin

#ifdef PDCDEBUG
char *rcsid_endwin = "$Header: C:\CURSES\portable\RCS\endwin.c 2.1 1993/06/18 20:19:50 MH Rel MH $";
#endif




/*man-start*********************************************************************

  endwin()	- restore initial terminal environment

  X/Open Description:
 	A program should always call endwin() before exiting or
 	escaping from curses mode temporarily.  This routine will
 	restore tty modes, move the cursor to the lower left corner
 	of the screen and reset the terminal into the proper non-visual
 	mode.  To resume curses after a temporary escape, refresh() or
 	doupdate() should be called.

  PDCurses Description:
 	At this time, endwin() must be followed by a call to initscr()
 	for temporary escapes.

 	In addition, endwin() will resize the screen, if necessary.

  X/Open Return Value:
 	The endwin() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int endwin( void );
 	X/Open Dec '88	int endwin( void );
 	BSD Curses	
 	SYS V Curses	

**man-end**********************************************************************/

int	endwin(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("endwin() - called\n");
#endif

	PDC_scr_close();
/*	resetty();*/
	if (_cursvar.orig_font != _cursvar.font)  /* screen has not been resized */
		{
		PDC_set_font(_cursvar.orig_font);
		resize(PDC_get_rows());
		}

	_cursvar.visible_cursor = FALSE;	/* Force the visible cursor */
	_cursvar.cursor = _cursvar.orig_cursor;
	curson();
	delwin(stdscr);
	delwin(curscr);
	stdscr = (WINDOW *)NULL;
	curscr = (WINDOW *)NULL;
	_cursvar.alive = FALSE;

	/*
	 * Position cursor so that the screen will not scroll until they hit
	 * a carriage return.
	 */
	PDC_gotoxy(PDC_get_rows() - 2, 0);
#ifdef	FLEXOS
	_flexos_8bitmode();
#endif
/*	PDC_fix_cursor(_cursvar.orig_emulation);*/
#ifdef UNIX
	if (exit_ca_mode != NULL)
		putp(exit_ca_mode);
#endif
#ifndef UNIX
	if (_cursvar.orig_font != _cursvar.font)  /* screen has not been resized */
#endif
		reset_shell_mode();
	return( OK );
}
