#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	resetty

#ifdef PDCDEBUG
char *rcsid_resetty = "$Header: C:\CURSES\portable\RCS\resetty.c 2.1 1993/06/18 20:20:54 MH Rel MH $";
#endif




/*man-start*********************************************************************

  resetty()	- save/restore terminal modes

  X/Open Description:
 	These routines save and restore the state of the terminal modes.
 	The savetty() function saves the current state in a buffer and
 	resetty() restores the state to what it was at the last call to
 	savetty().

  PDCurses Description:
 	FYI: It is very unclear whether this is a duplication of the
 	reset_prog_mode() and reset_shell_mode() functions or whether
 	this is a backing store type of operation.  At this time, they
 	are implemented similar to the reset_*_mode() routines.

  X/Open Return Value:
 	The resetty() function returns OK upon success otherwise ERR is
 	returned.

  Portability:
 	PDCurses	int resetty( void );
 	X/Open Dec '88	int resetty( void );
 	SysV Curses	int resetty( void );
 	BSD Curses	int resetty( void );

**man-end**********************************************************************/

int	resetty(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("resetty() - called\n");
#endif

#ifndef UNIX
	if	(c_save_tty.been_set == TRUE)
	{
		memcpy(&_cursvar, &c_save_tty.saved, sizeof(SCREEN));

		mvcur(0, 0, c_save_tty.saved.cursrow, c_save_tty.saved.curscol);
		if (PDC_get_ctrl_break() != c_save_tty.saved.orgcbr)
			PDC_set_ctrl_break(c_save_tty.saved.orgcbr);
		if (c_save_tty.saved.raw_out)
			raw();
		if (c_save_tty.saved.visible_cursor)
			curson();
		_cursvar.font = PDC_get_font();
		PDC_set_font(c_save_tty.saved.font);
		if (!PDC_scrn_modes_equal (PDC_get_scrn_mode(), c_save_tty.saved.scrnmode))
			PDC_set_scrn_mode(c_save_tty.saved.scrnmode);

		PDC_set_rows(c_save_tty.saved.lines);
	}
#endif
	return( c_save_tty.been_set ? OK : ERR );
}
