WITH ADA.Text_IO; USE ADA.Text_IO;
WITH My_Int_IO, My_Flt_IO; USE My_Int_IO, My_Flt_IO;

PROCEDURE Test_Math IS -- Test built in math operations

	A , B , I : Integer;
 	X : Float :=  -123.4567;  --  digits 8      (see ARM 3.5.7)

	PROCEDURE Power_Float(P, U : IN Integer) IS
	BEGIN
		FOR I IN P .. U LOOP
			Put("2 ** ");
			Put(I,4);
			Put(2.0 ** I,4,8,400);
			New_Line;
		END LOOP;
	EXCEPTION
		WHEN Numeric_Error =>
			Put_Line(" ************ Overflow *************");
	END Power_Float;
	PROCEDURE Power_Int IS
	BEGIN
		FOR I IN 0 .. 20 LOOP
			Put("    2 ** ");
			Put(I, WIDTH => 4);
			Put(2 ** I);
			IF ((I + 1) MOD 3) = 0 THEN
				New_Line;
			END IF;
		END LOOP;
	EXCEPTION
		WHEN Numeric_Error =>
			Put_Line(" ************ Overflow *************");
	END Power_Int;
BEGIN
	Put_Line("***** ARM 4.5.5. Multiplying Operators: REM and MOD *****");
     	Put     ("   A    B  REM  MOD    A    B  REM  MOD");
	Put_Line("    A    B  REM  MOD    A    B  REM  MOD");
	FOR A IN 10 .. 14 LOOP
		B := 5;
		Put(A,4);
		Put(B,5);
		Put((A REM B),5);
		Put((A MOD B),5);
		Put(-A,5);
		Put(B,5);
		Put(((-A) REM B),5);
		Put(((-A) MOD B),5);
		B := -5;
		Put(A,5);
		Put(B,5);
		Put((A REM B),5);
		Put((A MOD B),5);
		B := -5;
		Put(-A,5);
		Put(B,5);
		Put(((-A) REM B),5);
		Put(((-A) MOD B),5);
		New_Line;
	END LOOP;
	New_Line(2);
	Put_Line("***** Float formating (14.3.9) and POW (ARM 4.4) *****");
	Put(X); -- default format             
	Put("=[-1.2345670e+02]");
	New_Line;
	Put(X, Fore => 5, Aft => 3, Exp => 2);    
	Put("=[bbb-1.235e+2]");
	New_Line;
	Put(X, 5, 3, 0);                          
	Put("=[b-123.457]");
	New_Line;
	Power_Float(7,10);
	Power_Float(60,65);
	Power_Float(300,305);
	Power_Float(1020,1026);
	New_Line(2);
	Put_Line("***** Integer formating (ARM 14.3.8) and POW (ARM 4.4) *****");
	Power_Int;
END Test_Math;