/* gexecute.c */

/*
    Copyright (C) 1996 Chuck Kann  & Michael Bliss Feldman
			     ckann@seas.gwu.edu mfeldman@seas.gwu.edu
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.    


    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*  
*	Program name : gexecute.c
*       Heavily modified by Feldman for DJGPP version 2, May 1996
*	Usage	     : gexecute program.cof [arguments]
*
*	Purpose	     : To provide a trace back on an exception which GNAT
*		       thoughtlessly does not provide.
*		       
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>
	

/*  Run the program in Debug mode (ie using the debugger).  Once again
*   obvious, but put here for Ada hacks 
*/
int
Run_Debug(char **Args, int Num_Args)
{
    char *Program_Name = Args[0]; 
    int Name_Length;
    char Execute_Command[300];
    int i;

/*  Only run cof files */
    Program_Name = Args[0];
    Name_Length = strlen(Program_Name);
    if ((strcmp(&Program_Name[Name_Length-3], "cof") != 0))
    {
	printf("Program %s is not an \".cof\" file, cannot be run\n", 
                Program_Name);
	return 0;
    }

/*  Don't run if the program does not exist. */
    if (access(Program_Name, 0) != 0)
    {
	printf("File %s does not exist\n", Program_Name);
	return 0;
    } 


/*  
    Build a command which runs the program and appends the arguments.  
    gdb is getting its initialization commands from the gexecute.ini
    file in the GW-GNAT directory.
*/

    printf("Running %s\n", Program_Name);
    Program_Name[Name_Length-4] = '\0';

    
	sprintf( Execute_Command, 
                 "gdb -q -nx -x %s\\gexecute.ini %s.cof", 
                  getenv("GW-GNAT"),
                  Program_Name);

	for (i = 1; i < Num_Args ; ++i)
	{
	    strcat(Execute_Command, " ");
	    strcat(Execute_Command, Args[i]);
        }

        system(Execute_Command); 

    return 1;
}

void main(int argc, char *argv[])
{
    char *Program_Name[1];
    int i;
    int minimum_args = 1;

    /*  If no file name is entered, then ask the user for a file to run. */
    if (argc <= minimum_args)
    {
	Program_Name[0] = malloc(80 * sizeof(char));
	printf("Enter the name of the file to be run\n");
	gets(Program_Name[0]);
	Run_Debug(Program_Name, 0);
    }
    else
    {
	Run_Debug(argv+minimum_args, argc - minimum_args);
    }
}
