
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adatidle.adb "adatui-idle.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure idle is
   this_year    : calendar.year_number;
   this_month   : calendar.month_number;
   this_day     : calendar.day_number;
   this_day_dur : calendar.day_duration;

   subtype hour_t     is integer range 0..23;  
   subtype minute_t   is integer range 0..59;  
   subtype second_t   is integer range 0..59;  
   subtype duration_t is integer range 0..86_400;  

   this_hour     : hour_t;
   this_minute   : minute_t;
   this_second   : second_t;
   this_duration : duration_t;
--
-- Defining time display format
-- Time is displayed as "YYYY/MM/DD  hh:mm:ss" 
--
   time_string : string(1..20);
   year_msd    : constant :=  1;
   year_lsd    : constant :=  4;
   month_msd   : constant :=  6;
   month_lsd   : constant :=  7;
   day_msd     : constant :=  9;
   day_lsd     : constant := 10;
   hour_msd    : constant := 13;
   hour_lsd    : constant := 14;
   minute_msd  : constant := 16;
   minute_lsd  : constant := 17;
   second_msd  : constant := 19;
   second_lsd  : constant := 20;
--
-- using magic numbers for now...
--
   time_charv    : aliased c.charv(1..80);
   time_charp    : c.charp;
   void          : c.signed_int;
   column        : c.signed_int;

begin
   calendar.split (
      date    => calendar.clock,
      year    => this_year,
      month   => this_month,
      day     => this_day,
      seconds => this_day_dur );

   this_duration := integer ( this_day_dur );

--
-- Build time string
--
   integer_io.put (
      to   => time_string(year_msd..year_lsd),
      item => this_year );

   time_string(year_lsd + 1) := '/';
   integer_io.put (
      to   => time_string(month_msd..month_lsd),
      item => this_month );

   time_string(month_lsd + 1) := '/';
   integer_io.put (
      to   => time_string(day_msd..day_lsd),
      item => this_day );

   time_string(day_lsd + 1 .. day_lsd + 2) := "  ";
   this_hour     := this_duration  /  3600; 
   this_duration := this_duration mod 3600;
   integer_io.put (
      to   => time_string(hour_msd..hour_lsd),
      item => this_hour );

   time_string(hour_lsd + 1) := ':';
   this_minute := this_duration  /  60 ; 
   this_second := this_duration mod 60;
   integer_io.put (
      to   => time_string(minute_msd..minute_lsd),
      item => this_minute );

   time_string(minute_lsd + 1) := ':';
   integer_io.put (
      to   => time_string(second_msd..second_lsd),
      item => this_second );
--
-- Replace blanks preceeding a digit with a zero
--
   if time_string(year_msd)  = ' ' then
      time_string(year_msd) := '0';
   end if;

   if time_string(month_msd)  = ' ' then
      time_string(month_msd) := '0';
   end if;

   if time_string(day_msd)  = ' ' then
      time_string(day_msd) := '0';
   end if;

   if time_string(hour_msd)  = ' ' then
      time_string(hour_msd) := '0';
   end if;

   if time_string(minute_msd)  = ' ' then
      time_string(minute_msd) := '0';
   end if;

   if time_string(second_msd)  = ' ' then
      time_string(second_msd) := '0';
   end if;
--
-- Convert time string into a C-style string.
-- Using procedure form of interfaces.c.to_c to avoid raising
-- Constraint_Error due to mismatch in lengths of item and target.
-- 
   declare
      count : interfaces.c.size_t;
   begin
      interfaces.c.to_c (
	 item   => time_string,
	 target => time_charv,
	 count  => count );
   end;
--
-- Display time string in title window
--
   column := c.signed_int ( bw - time_string'length - 2 );
--
-- using unchecked access because type c.charp is defined at a higher
-- level than temp_charv - creates a potential for dangling pointers
--
   time_charp := time_charv'unchecked_access;

   void := pdcurses.mvwaddstr ( title_window, 0, column, time_charp ); 
   void := pdcurses.wrefresh ( title_window );
end idle;
