WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Exception_Loop IS
------------------------------------------------------------------
--| Illustrates how to write a robust input loop that
--| prompts user to re-enter invalid input and
--| refuses to continue until input is good.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  MinVal : CONSTANT Integer := -10;
  MaxVal : CONSTANT Integer :=  10;
  SUBTYPE SmallInt  IS Integer RANGE MinVal .. MaxVal;

  InputValue: SmallInt;
  Sum:        Integer;
            
BEGIN -- Exception_Loop

  Sum := 0;

  FOR Count IN 1..5 LOOP -- counts the five values we need to read

    LOOP      -- inner loop just to control robust input
      BEGIN   -- block for exception handler

        Ada.Text_IO.Put(Item => "Enter an integer between ");
        Ada.Integer_Text_IO.Put(Item => SmallInt'First, Width => 0);  
        Ada.Text_IO.Put(Item => " and ");
        Ada.Integer_Text_IO.Put(Item => SmallInt'Last, Width => 0);  
        Ada.Text_IO.Put(Item => " > ");
        Ada.Integer_Text_IO.Get(Item => InputValue);

        EXIT; -- leave the loop only upon correct input

      EXCEPTION
        WHEN Constraint_Error =>
          Ada.Text_IO.Put ("Value entered is out of range. Please try again.");
          Ada.Text_IO.New_Line;
        WHEN Ada.Text_IO.Data_Error =>
          Ada.Text_IO.Put ("Value entered not an integer. Please try again.");
          Ada.Text_IO.New_Line;
          Ada.Text_IO.Skip_Line;

      END;    -- block for exception handler
    END LOOP;
    -- assert: InputValue is in the range MinN to MaxN   

    Sum := Sum + InputValue; -- add new value into Sum
  END LOOP;

  Ada.Text_IO.Put (Item => "The sum is ");
  Ada.Integer_Text_IO. Put (Item => Sum, Width => 1);
  Ada.Text_IO.New_Line;

END Exception_Loop;
