--
--    Program : Fibb.ada
--    Purpose : This program recursively calculates a Fibonacci number.  
--      A Fibonacci number is the sum of the previous two Fibonacci numbers. 
--      The Fibonacci series is
--          1 1 2 3 5 8 13 21 ...
--
--    To use with GWUMON : To use this program with GWUMON, from the command
--              line type:
--                       adacomp -a -b -mFibonacci fibb.ada
--                       gwumon -mFibonacci
--
--    Take the default options on the first screen (speed = 6, exceptions = yes,
--              and tasks = no) by hitting the "Esc" key.  Change from a Small
--      Window to a Large Window on the second screen.
--
--    The purpose of this program is to show a large amount of recursion.
--    Therefore, when prompted for the number to be calculated, choose 5. 
--    This will cause many recursive calls of Fib_Calc.
--    
--    Notice that each time Fib_Calc is called, a new window is opened until
--    the screen is filled with windows. At that point, no new windows are
--    created, but notice that the highest level window "Scrolls" off to the
--    upper right and is no longer visable.
--
--    When the program has gotten to the final window, notice how it begins
--    to scroll the windows back on to the screen as the call stack unwinds.
--    When all the programs on the stack are back on the screen, the stack
--    continues to unwind, until there is only a single procedure left on
--    the screen.  This shows the call stack, and the recursion of the program.
--
WITH Text_IO;
WITH My_Int_IO;
PROCEDURE Fibonacci IS
  Temp : Positive;
  FUNCTION Fib_Calc( Current_Num: IN Positive) RETURN Positive IS
    Result: Positive;
  BEGIN
    Text_IO.Put("Input is ");
    My_Int_IO.Put(Current_Num);
    Text_IO.New_Line;
    IF Current_Num = 1 OR Current_Num = 2 THEN
      Result := 1;
    ELSE
      Result := Fib_Calc (Current_Num - 2) + Fib_Calc( Current_Num - 1 );
    END IF;
    Text_IO.Put("  Result is ");
    My_Int_IO.Put(Result);
    Text_IO.New_Line;
    RETURN Result;
  END Fib_Calc;
BEGIN
  Text_IO.Put_Line( "Enter the Fibonacci number to be calculated" );
  My_Int_IO.Get( Temp );
  Temp := Fib_Calc( Temp );
  My_Int_IO.Put( Item => Temp );
  Text_IO.New_Line;
END Fibonacci;
    
