/*    uxarc.c

      Universal archive processing program.
      Assumes PKPAK/PKUNPAK for .ARC files.
              PKZIP/PKUNZIP for .ZIP files.
              LHARC/LHARC   for .LZH files.

      Programmer:  Neil McAllister

      Source written by Neil McAllister.  Released
      to the public domain for use without profit.
*/

#include <stdio.h>
#include <string.h>

#define   ZIP       1
#define   ARC       2
#define   LZH       3


int main( int argc, char *argv[] )
  {
    char filename[15];
    char cmd_line[111];
    unsigned char arcfile_arg = 0;
    unsigned char x = 1;
    unsigned char flag = 0;
    
    puts( "\nUXARC Universal Archive Extractor 1.0   Written by Neil McAllister" );
    if ( argc == 1 )
      {
        puts( "  Usage: UXARC <options><arcfile>" );
        puts( "  This program will take the place of separate calls to" );
        puts( "  PKUNPAK, PKUNZIP, and LHARC." );
        return 0;
      }
    while ( !arcfile_arg )
      if ( argv[x][0] != '-'  &&  argv[x][0] != '/' )
        arcfile_arg = x;
      else
        argv[x++][0] = '/';
    if ( !arcfile_arg )
      {
        puts( "***** FATAL: No archive file specified on command line." );
        return 1;
      }
    for ( x = 0; argv[arcfile_arg][x] != '\0'; x++ )
      if ( argv[arcfile_arg][x] == '.' )
        {
          ++x;
          if ( !strcmpi(&argv[arcfile_arg][x], "ZIP") )
            {
              flag = ZIP;
              strcpy( cmd_line, "PKUNZIP" );
            }
          else
            if ( !strcmpi(&argv[arcfile_arg][x], "ARC") )
              {
                flag = ARC;
                strcpy( cmd_line, "PKUNPAK" );
              }
            else
              if ( !strcmpi(&argv[arcfile_arg][x], "LZH") )
                {
                  flag = LZH;
                  strcpy( cmd_line, "LHARC" );
                }
              else
                {
                puts( "***** FATAL: Unknown archive type on command line." );
                  return 1;
                }
        }
    if ( !flag )
      {
        strcpy( filename, &argv[arcfile_arg][0] );
        if ( fopen(strcat(filename, ".ZIP"), "r") != NULL )
          {
            flag = ZIP;
            fcloseall();
            strcpy( cmd_line, "PKUNZIP" );
          }
        else
          {
            strcpy( filename, &argv[arcfile_arg][0] );
            if ( fopen(strcat(filename, ".ARC"), "r") != NULL )
              {
                flag = ARC;
                fcloseall();
                strcpy( cmd_line, "PKUNPAK" );
              }
            else
              {
                strcpy( filename, &argv[arcfile_arg][0] );
                if ( fopen(strcat(filename, ".LZH"), "r") != NULL )
                  {
                    flag = LZH;
                    fcloseall();
                    strcpy( cmd_line, "LHARC" );
                  }
                else
                  {
                    puts( "***** FATAL: Could not open specified arcfile." );
                    return 1;
                  }
              }
          }
      }
    if ( argv[1][0] != '/'  &&  flag == LZH )
      strcat( cmd_line, " /x" );
    for ( x = 1; x < argc; x++ )
      {
        strcat( cmd_line, " " );
        strcat( cmd_line, &argv[x][0] );
      }
    system( cmd_line );
    return 0;
  }
