; MOUSE HANDLING CODE
; includes a "basic" mouse driver for the real-mode-int33h
; and the mouse specific XID code.

; default microsoft mouse
MAIN_MOUSE  =0       
STICK_MOUSE =1
KEYB_MOUSE  =2
EXTRA_MOUSE =3
       
       ; MOUSE DATA TABLE BEGINS HERE
extrn _MouseName:dword ;4  
; pointers to asciiz strings containing the mouse names     

       ; coordinate ranges
extrn _MouseX1:dword ;4 
; min. x
extrn _MouseX2:dword ;4 
; max. x
extrn _MouseY1:dword ;4 
; min. y
extrn _MouseY2:dword ;4 
; max. y
extrn _MouseZ1:dword ;4 
; min. z
extrn _MouseZ2:dword ;4 
; max. z
       ; N.B. angle ranges are always between 0..360
       
        ; mouse stepping sensitivity
        ; (controls ballistic/stepping if supported by driver)
        ; they can range between 0 (slowest) to 100 (fastest)
        ; and they are just pseudo-indexes 
        ; the driver uses together with the minimum and maximum coords
        ; to calculate the actual sensitivity
extrn _MouseMX:dword ;4
extrn _MouseMY:dword ;4        
extrn _MouseMZ:dword ;4
        ; mouse coords  
                      ; "low"        "high"
extrn _MouseX:dword ;4  
; left     to right
extrn _MouseY:dword ;4  
; up       to down
extrn _MouseZ:dword ;4  
; backward to forward
extrn _AngXY:dword ;4  
; right   to up
extrn _AngZY:dword ;4  
; forward to up     
extrn _AngXZ:dword ;4  
; right   to forward
extrn _Buttons:dword ;4  
; Mouse button flags
               ; meaning of _Buttons
               ; bit0 = button 0
               ; bit1 = button 1
               ; bit2 = button 3
               ; ...
               ; bitN = button N
               ; YEAH! This baby can support up to 32 buttons
               ; but usually a mouse will have 2..3 buttons
               ; (duplicate the button3 function on the keyboard 
               ;  if you wanna be safe)
               ; If you duplicate button functions on the keyboard
               ; you don't have to check the existence of buttons.
               ; Anyway, if you own one of those weird mouse-with-keypad
               ; you can fully use it once you get a XID driver.
; MOUSE DATA TABLE ENDS HERE               

extrn _MouseReset:near
        ; in: esi = mouse device id
        ; out:
        ;    if      eax == 00000h then mouse not installed
        ;    else if eax == 0FFFFh then
        ;             mouse installed
        ;             mouse hidden & positioned on center of screen
        ;             (actually to the center of the x-y range set into
        ;              the mouse data table)
        ;             coordinates not supported are set to 0
        ;             angles not supported are set to -1
        ;             the supported ones are initially set to zero
        
extrn _MouseRead:near
        ; in:
        ; esi = mouse device index (0..3)
        ; out:
        ;      _MouseX,Y,Z _AngXY,ZY,XZ _Buttons 
        ;      relative to the selected mouse device set according to the
        ;      current status
        
extrn _MouseWrite:near
        ; in: esi= mouse device index
        ; out: mouse status set according to the values in the mouse data table
        
extrn _MouseRange:near
        ; in: esi= mouse device index
        ; out: mouse movement range and sensitivity set according
        ;      to the values in the mouse data tables
        
extrn _MouseSetup:near
        ; in: esi =mouse device index
        ; out: mouse set up to new sensitivity and other "internal settings"
        ;      values specific to this device
                
