
111/118 20 Nov 91 12:58:00
From:   Alain Lachapelle
To:     Luns Tee
Subj:   Breakpoint INT
Attr:   
------------------------------------------------
 > Int or a Call, it swaps the first byte after that instruction with a
 > CCh - Int 3, and then executes the code to be stepped over. The
 > debugger has already hooked Int 3, and when it regains control,
 > replaces the original instruction and stops there.

This part isn't clear for me.  I'm writing now a small debugger for my external 
8088 (display regs, modify regs) and what you're writing here looks pretty much 
like what's described in the 8088 Intel manual but, I still fail to see the 
purpose of doing the swapping.  See, the way I'm making it is:

    mov   ax, 5Ah       ; sample code to break into
    out   82551pa, al

Then I'm re-assembling with INT 3h squeezed in there:

    mov   ax, 5Ah
    db    0CCh          ; or INT 3h, whatever.
    out   82551pa, al

And this would be the INT 3h handler (simple crude sample) :

 INT3h PROC
     call    keyboard            ; wait for a key before going on
     iret
 INT3h ENDP

Assuming that the INT 3h is properly installed, each time the processor will 
encounter 0CCh, it will wait for a key before going on, that is, resuming 
execution at the main code level (in this case, doing the OUT command).  So 
what's that business now with swapping one byte of the main code to execute 
with 0CCh?  What are the advantages and purpose of using such a technique?

Thanks,


Alain

---
 * Origin: Vive la difference (1:167/90.13)


108/115 22 Nov 91 21:50:56
From:   Luns Tee
To:     Alain Lachapelle
Subj:   Breakpoint INT
Attr:   
------------------------------------------------
 AL> swapping.  See, the way I'm making it is:

 AL>     mov   ax, 5Ah       ; sample code to break into
 AL>     out   82551pa, al

 AL> Then I'm re-assembling with INT 3h squeezed in there:

 AL>     mov   ax, 5Ah
 AL>     db    0CCh          ; or INT 3h, whatever.
 AL>     out   82551pa, al
 
 
   That'd be okay except that when debugging a program, one generally does not 
go peppering the source code with Int 3s and recompiling.
 
 AL> Assuming that the INT 3h is properly installed, 
 AL> each time the processor will encounter 0CCh, it 
 AL> will wait for a key before going on, that is, 
 AL> resuming execution at the main code level (in this 
 AL> case, doing the OUT command).  So what's that 
 AL> business now with swapping one byte of the main 
 AL> code to execute with 0CCh?  What are the advantages 
 AL> and purpose of using such a technique?
 
   Again, it's basically what I just said. Here's an Int 3h handler off the top 
of my head.
 
nextaddr  dd     ?
swapinst  db     ?
 
Int3handler
       push      bp
       mov       bp,sp
       push      ax
         ...etc...
       push      cs
       pop       ds
       dec     word ptr [bp+2] ; not sure if this is right - I'm presuming
                               ; the address put on the stack is that of
                               ; the byte after the Int 3
       les       bx,[bp+2]
      mov       ax,es
      cmp       word ptr nextaddr+2,ax; verify we're where we think we are
      jnz       touser
      cmp       word ptr nextaddr,bx
      jnz       touser
       mov      al,swapinst
       mov      es:[bx],swapinst ; replace the original instruction
touser:
       call     drivel ; pass address of current instr. in es:bx
                       ; return address of next instruction to stop at
                       ; in es:bx too
      mov      al,0CCh ; int3h
      xchg     es:[bx],al
      mov      swapinst,al
 
      pop etc..
      iret
Int3handler
 
   The entry to the debug cycle is at touser - you set up an appropriate stack 
frame as though the code had been called from an Int3 at the first instruction 
of the program. Drivel can look at the program's registers on the stack by 
referencing them relative to bp - i.e. the contents of ax for the program being 
debugged can be found in [bp-2], and the rest depend on what you put in for the 
...etc... there.
   drivel has to look at the instruction at es:[bx] and determine how long it 
is, then return in es:[bx] a pointer to the next instruction. Or, if you want 
to let things run unchecked up to a certain address, return that address 
instead - i.e. debug's g <address> command.
 
   This will give you a procedure level stepping - i.e. any CALL will get 
skipped. You can make drivel a bit smarter and have it look at where the CALL 
points to, and return ES:BX pointing to that.
  RETs and IRETs are pretty easy - just get the appropriate address off the 
stack, again referencing against BP.
 
  An embelishment you may go through would be to make use of Int 1 as well. 
Figuring out how to code for that is left as an excercise for the reader. ;-)

--- Maximus 2.00
 * Origin: BlakStar Systems, Toronto, Canada: (416)656-4532 (1:250/646)

