
024/061 06 Dec 91 11:52:04
From:   David Welch
To:     Jerry Kassebaum
Subj:   Re: Tiny Com Program
Attr:   
------------------------------------------------
This should help get your feet wet:
.model tiny
.code
org 100h
entry:
    push cs                     ;set up data segment
    pop ds
    push cs                     ;setup extra segment
    pop es
    mov ah,09h                  ;print opening message
    mov dx,offset mess
    int 21h
    cli                         ;disable maskable interrupts
    mov dx,03FBh                ;enable baud rate divisor registers
    mov al,80h
    out dx,al
    mov dx,03F8h                ;set baud rate dividor low byte
    mov al,0Ch
    out dx,al
    mov dx,03F9h                ;set baud rate divisor high byte
    mov al,00h
    out dx,al
    mov dx,03FBh                ;set modem control
    mov al,03h
    out dx,al
    mov ax,350Ch                ;get old com irq vector
    int 21h
    mov cs:[oldoff],bx
    mov bx,es
    mov cs:[oldseg],bx
    mov ax,250Ch                ;set new com irq vector
    mov dx,offset commisr
    int 21h
    mov dx,03F9h                ;interrupt on data received
    mov al,01h
    out dx,al
    mov dx,03FCh                ;enable interrupts and force dtr
    mov al,09h
    out dx,al
    in al,21h                   ;enable irq on pic
    and al,0EFh
    out 21h,al
    sti                         ;enable maskable interrupts
top:
    cmp [count],0000h           ;check for chars in buffer
    jz skipa
    mov bx,[bufst]              ;get next character
    mov al,[bx]
    inc bx
    cmp bx,offset eob
    jnz tskip
    mov bx,offset buffer
tskip:
    mov [bufst],bx
    dec [count]
    mov ah,0Eh                  ;print character
    mov bx,000Fh
    int 10h
skipa:
    mov ah,01h                  ;check for key waiting
    int 16h
    jz top
    mov ah,00h                  ;get key waiting
    int 16h
    cmp ax,1000h                ;compare for ALTQ
    jz goodbye
    mov dx,03F8h                ;transmit character
    out dx,al
    jmp top
goodbye:
    cli                         ;disable maskable interrupts
    in al,21h                   ;disable irq on pic
    or al,10h
    out 21h,al
    mov dx,03F9h                ;do not interrupt
    mov al,00h
    out dx,al
    mov dx,03FCh                ;drop dtr, disable interrupts
    out dx,al
    mov ax,250Ch                ;reset old com vector
    mov dx,cs:[oldseg]
    mov ds,dx
    mov dx,cs:[oldoff]
    int 21h
    sti                         ;enable maskable interrupts
    mov ax,4C00h
    int 21h
commisr:
    cli                         ;disable maskable interrupts
    push ax                     ;save registers
    push bx
    push dx
    mov dx,03F8h                ;receive character
    in al,dx
    mov bx,cs:[bufed]           ;put character in buffer
    mov cs:[bx],al
    inc bx
    cmp bx,offset eob
    jnz commskip
    mov bx,offset buffer
commskip:
    mov cs:[bufed],bx
    inc cs:[count]
    mov al,20h
    out 20h,al
    pop dx                      ;restore registers
    pop bx
    pop ax
    sti                         ;enable maskable interrupts
    iret                        ;interrupt return
mess    db 'TERM (C) David Welch, 1991',0Dh,0Ah
        db 'ALT-Q to quit',0Dh,0Ah,24h
oldoff  dw  0000h
oldseg  dw  0000h
count   dw  0000h
bufst   dw  offset buffer
bufed   dw  offset buffer
buffer  db  16 dup(0)
eob:
END entry
.
david


--- Opus-CBCS 1.73a
 * Origin: The Desert Dolphin WOCin New Mexico 505 523-2811 (1:305/105.0)

