;----------------
; An example of the 386 protected mode. PD from Arne de.Bruin
; (Note: doesn't work in V86 mode (used by most memory managers which
;  provide EMS, use a clean boot instead)
        model small
        ideal
        codeseg
        P386
        assume cs:@code,ds:@code,es:@code,ss:@code
        org 100h
begin:
        jmp Start
GDTPtr        df ?          ; Pointer to the global descriptor table

GDT           dq 0          ; The first GDT entry (can't be used)

; CS (GDT entry 1)
CSDes         dw 0FFFFh     ; Lo Limit
              dw ?          ; Segment base
              db ?          ; Segment base
              db 9Ah        ; P:1, DPL:00, DT:1, Type:1010 (exec/read code)
              dw 0000h      ; Hi Limit:0, G:0, DB:0, res:0, vf:0, HiBase:0

; Video (GDT entry 2)
VioDes        dw 01000h     ; Lo Limit
              dw 08000h     ; Segment base  ( Color Textmode screen address )
              db 0Bh        ; Segment base  ( (physical address 0b8000h)    )
              db 92h        ; P:1, DPL:00, DT:1, Type:0010 (read/write data)
              dw 0000h      ; Hi Limit:0, G:0, DB:0, res:0, vf:0, HiBase:0
;64K Data (GDT entry 3)
Data64Des     dw 0FFFFh     ; Lo Limit
              dw ?          ; Segment base (lo 16 bit from 24 bit)
              db ?          ; Segment base (hi 8 bit from 24 bit)
              db 92h        ; P:1, DPL:00, DT:1, Type:0010 (read/write data)
              dw 0000h      ; Hi Limit:0, G:0, DB:0, res:0, vf:0, HiBase:0
GDTSize = $-GDT

Start:
        xor   eax,eax                   ; Clear EAX
        mov   ax,cs                     ; Save current code seg
        mov   [cs:ActSeg],ax            ; For return to real mode
        shl   eax,4                     ; Calculate physical address
        push  eax                       ; for CS, by multiplying with 16
        mov   [word cs:CSDes+2],ax      ; Save low 16 bits in descriptors
        mov   [word cs:Data64Des+2],ax
        shr   eax,16
        mov   [byte cs:CSDes+4],al      ; Save hi 8 bits in descriptos
        mov   [byte cs:Data64Des+4],al
        pop   eax                       ; Make a pointer to the GDT
        xor   ebx,ebx
        mov   bx,offset GDT
        add   eax,ebx
        mov   [dword cs:GDTPtr+2],eax   ; And save it in our variable
        mov   [word cs:GDTPtr],GDTSize  ; with the length of the GDT

        cli                             ; Clear interrupts, we don't do
                                        ; interrupt support for the
                                        ; protected mode
        lgdt  [cs:GDTPtr]               ; Let the CPU know where the GDT is
        mov   eax,cr0
        or    eax,1
        mov   cr0,eax                   ; And turn protected mode bit on
        db 0eah                         ; Opcode for FAR jump
        dw offset ProtMode, 0008h       ; Address to jump to
                                        ; (0008h is the segment selector of
                                        ; this codeseg, 0008h is 0001h (entry
                                        ; number in the GDT) in bits 15-3
                                        ; and bits 2-0 are zero. (CPL=0, TI=0)
MyText db 'PROTECTED MODE!'             ; Text to display
MyTextLen = $-MyText
ProtMode:
        mov ax,2*8+0                    ; Load video address selector
                                        ; (selector no. 2, CPL=0, TI=0)
        mov es,ax                       ; And store in ES
        xor di,di                       ; Offset for the string
        push cs                         ; Copy CS to DS
        pop ds                          ; (the string is in CS)
        mov si,offset MyText            ; Offset of the string
        mov ah,128+64+15                ; Attribute (blinking white on red)
        mov cx,MyTextLen                ; Number of bytes to write
@@LoopIt:                               ; Copy to video buffer
        lodsb
        stosw
        loop @@LoopIt
        mov ax,3*8+0                    ; Load real mode compitable
                                        ; segment selectors
        mov es,ax                       ; in ES
        mov ds,ax                       ; and DS
        mov eax,cr0
        and eax,0fffffffeh
        mov cr0,eax                     ; Turn protected mode bit off
        db 0eah                         ; And jump with a FAR jump
        dw offset RealMode              ; to load the correct CS
actseg  dw ?                            ; we prevously saved
RealText db 'Back into real mode...$'   ; Text to display (with DOS)
RealMode:
        sti                             ; Interrupts are again possible
        mov ax,cs                       ; Load segment of string
        mov es,ax                       ; in ES
        mov ds,ax                       ; and DS
        mov dx,offset RealText          ; And load offset in DX
        mov ah,9                        ; DOS function 9, print string
        int 21h                         ; Let DOS display it
        mov ah,8                        ; DOS function 8, wait for a key
        int 21h                         ; Let DOS wait
        mov ax,4c00h                    ; DOS function 4ch, terminate
        int 21h                         ; Let DOS terminate

        end begin
