;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; IDT.ASM
;
; Function: Set up the protected mode IDT and vector all ints and processor
;   traps as INT vectors so IF will be cleared when we are in
;   protected mode
;
	.386P


include segs.asi
include tss.asi
include idt.asi
	public setidt,exc1,exce
SEG386	segment
	extrn	emulate: PROC, transfer: PROC, endprotection : PROC
	extrn	emu386: PROC, GFTrapFrame : PROC
	extrn	MapTrap:PROC, MapStep :PROC
SEG386	ends


SEG386Data 	segment
	extrn MemBase : DWORD, MemFree : DWORD, TSSBase : DWORD, tGDT : BYTE
pIDT	dw	IDTSIZE-1
	dd	0
SEG386Data	ends


SEG386	segment
	assume cs:dgroup,ds:dgroup, fs: ABSDATA
;
; Base addresses for 386 traps
;
; (vectors 0 -1f)
traptab	dd	dgroup:exc0,dgroup:exc1,dgroup:exc2,dgroup:exc3,dgroup:exc4,dgroup:exc5,dgroup:exc6,dgroup:exc7
	dd	dgroup:exc8,dgroup:exc9,dgroup:exca,dgroup:excb,dgroup:excc,dgroup:emulate,dgroup:exce,dgroup:excf
	dd	dgroup:exc10
	dd	0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0
;
; Base addresses for hardware interrupts
;
; (vectors 20-2f)
;
inttab	dd	dgroup:int0,dgroup:int1,dgroup:int2,dgroup:int3,dgroup:int4,dgroup:int5,dgroup:int6,dgroup:int7
	dd	dgroup:int8,dgroup:int9,dgroup:inta,dgroup:intb,dgroup:intc,dgroup:intd,dgroup:inte,dgroup:intf
;
; Trap and interrupt vectors
;
exc0:	TRANSFERINT	0
exc1:	
	call	MapStep
	TRANSFERINT	1
exc2:	TRANSFERINT	2
exc3:	TRANSFERINT	3
exc4:	TRANSFERINT	4
exc5:	TRANSFERINT	5
exc6:	TRANSFERINT	6
exc7:	TRANSFERINT	7
exc8:	QUIT 8
exc9:	TRANSFERINT	9
exca:	QUIT 10
excb:	QUIT 11
excc:	QUIT 12
exce:
	call	MapTrap		; Handle page fault on ROM write
	QUIT	14
excf:	QUIT 15
exc10:	TRANSFERINT	10h
int0:	TRANSFERINT	8
int1:	TRANSFERINT	9
int2:	TRANSFERINT	0ah
int3:	TRANSFERINT	0bh
int4:	TRANSFERINT	0ch
int5:	TRANSFERINT	0dh
int6:	TRANSFERINT	0eh
int7:	TRANSFERINT	0fh
int8:	TRANSFERINT	70h
int9:	TRANSFERINT	71h
inta:	TRANSFERINT	72h
intb:	TRANSFERINT	73h
intc:	TRANSFERINT	74h
intd:	TRANSFERINT	75h
inte:	TRANSFERINT	76h
intf:	TRANSFERINT	77h
;
; Make an int gate
;
loadint	proc
	mov	word ptr fs:[edi+edx*8],ax	; Low word of vector addr
	shr	eax,16
	mov	word ptr fs:[edi+edx*8+6],ax	; High word of vector addr
	mov	word ptr fs:[edi+edx*8+2],bx	; CS Selector
	mov	byte ptr fs:[edi+edx*8+4],0	; Params to push = 0
	mov	byte ptr fs:[edi+edx*8+5],08eh	; Assume int
	ret			;
loadint	endp
;
; Main routine to initialize IDT
;
setidt	proc
	mov	edi,[TSSBase]		; IDT is at end of TSS
	add	edi,TSSSIZE-IDTSIZE	;
	mov	dword ptr [pIDT+2],edi	; Save IDT address for lidt command
	mov	esi,offset dgroup:traptab ; Get the trap list
	mov	ecx,NUMEXCEPT		; Number of traps
	mov	bx,CS386		; BX = code seg selector
	sub	edx,edx			; Init trap num = 0
@@silp:
	lodsd				; Get trap vect
	call	loadint			; Load it as an int
	inc	edx			; Inc trap num
	loop	@@silp			; Loop till done
	mov	esi,offset dgroup:inttab; Get interrupt list
	mov	ecx,NUMINT		; Number of interrupts
@@silp2:
	lodsd				; Get interrupt vect
	call	loadint			; Load it as an int
	inc	edx			; Inc int num
	loop	@@silp2			; Loop till done
	lidt	fword ptr [pIDT]	; Load the prot mode IDT
	ret
setidt	endp
SEG386	ends
	end