;From  TENIE REMMEL                                          1:202/747.0
 
 Ideal 
 
 Model Tiny 
 CodeSeg 
 P186 
 Org 100h 
 
 Proc           Program 
                   
                push 0A000h         ;Point ES to video memory 
                mov si,sp           ;Save stack pointer 
                pop es 
                mov al,13h          ;Change video mode 
                int 10h             ;to 320x200 
                xor di,di           ;Zero DI 
                mov cl,200          ;Height of screen in pixels 
 CalcRow:       push cx             ;Save the row pointer on the stack 
                mov cx,320          ;Width of screen in pixels 
 CalcPixel:     push cx             ;Save the column counter on stack 
                mov cl,103          ;Init color counter 
                xor bx,bx           ;Zero i coefficient 
                xor dx,dx           ;Zero j coefficient 
 CycleColors:   push dx             ;Save j 
                mov ax,bx           ;AX = i 
                sub ax,dx           ;AX = i - j 
                add dx,bx           ;DX = i + j 
                imul dx             ;DX:AX = (i+j)*(i-j) = i*i - j*j 
                mov al,dl           ;Save middle bits (i*i - j*j)/100h 
                pop dx              ;Restore j 
                xchg ah,al          ;Swap hi, lo middle bits 
                xchg bx,ax          ;Now swap new i with old i 
                sub bx,[si-2]       ;Subtract vertical line counter 
                test bh,bh          ;Is i >= 256 ? 
                jg Draw             ;If so, draw this pixel 
                imul dx             ;Now DX:AX = old i * j 
                mov dh,dl           ;Get middle bits again

                mov dl,ah           ;Put them in DX 
                add dx,dx           ;Save middle bits (i * j)/200h 
                sub dx,[si]         ;Subtract out horz line counter 
                loop CycleColors    ;Loop back 
 Draw:          xchg ax,cx          ;Swap color into AL and clear AH 
                stosb               ;Write pixel 
                pop cx              ;Restore column counter 
                loop CalcPixel      ;Loop back 
                pop cx              ;Restore row counter 
                loop CalcRow        ;Loop back 
                   
                xor ax,ax           ;Wait for a key 
                int 16h 
                mov ax,3            ;Change video mode back to text mode 
                int 10h 
                ret 
 
 EndP           Program 
 
 End Program 
 
