TITLE  Better Bubble Sort (EX55.ASM)
          PAGE      ,132
DATA	  SEGMENT   PARA 'DATA'
SAVE_CNT  DW	    ?
START_ADDR  DW      ?
DATA      ENDS
OUR_CODE  SEGMENT   PARA 'CODE'
	  PUBLIC    BUBBLE
BUBBLE    PROC      FAR
          ASSUME    CS:OUR_CODE,DS:DATA
	  PUSH	    DS	             ;Save caller's registers
	  PUSH	    CX
	  PUSH	    AX		     
	  PUSH	    BX
	  MOV       AX,DATA	     ;Initialize DS
	  MOV       DS,AX
	  MOV	    START_ADDR,DI    ;Save starting address in memory
	  MOV	    CX,ES:[DI]	     ;Fetch element count
	  MOV	    SAVE_CNT,CX	     ;Save this value in memory
INIT:	  MOV	    BX,1	     ;Exchange flag (BX) = 1
	  DEC	    SAVE_CNT	     ;Get ready for count-1 compares
	  JZ	    SORTED	     ;Exit if SAVE_CNT is 0
	  MOV	    CX,SAVE_CNT      ; and load this count into CX
	  MOV	    DI,START_ADDR    ;Load start address into DI
NEXT:	  ADD	    DI,2	     ;Address a data element
	  MOV	    AX,ES:[DI]	     ; and load it into AX
	  CMP	    ES:[DI+2],AX     ;Is next el. < this el.?
	  JAE	    CONT	     ; No.  Go check next pair
	  XCHG      ES:[DI+2],AX     ; Yes.  Exchange these elmts.
	  MOV	    ES:[DI],AX
	  SUB	    BX,BX	     ; and make exchange flag 0
CONT:	  LOOP	    NEXT	     ;Process entire list
	  CMP	    BX,0	     ;Any exchanges made?
	  JE	    INIT	     ; If so, process list again
SORTED:   MOV	    DI,START_ADDR    ; If not, restore registers
	  POP	    BX
	  POP	    AX
	  POP	    CX
	  POP	    DS
	  RET			     ;  and exit.
BUBBLE    ENDP
OUR_CODE  ENDS
   	  END       BUBBLE
                                                                                               