;String uppercasing function.
;
;Declare as follows:
;	{$F+}
;	{$L UC.OBJ}
;	FUNCTION Uc(S : STRING) : STRING; EXTERNAL;
;Call as follows:
;	Uppercased := Uc(S);
;
;Courtesy of Toad Hall

;Total stack (caller's plus work stack)
cstk	STRUC
bpsave	DW	0			;save BP here
retaddr	DD	0			;points to return address
straddr	DD	0			;points to string address
strptr	DD	0			;ptr to temporary string location
cstk	ENDS

PARAMSIZE	EQU SIZE straddr	;size of parameter list

PUBLIC	Uc				;function name declaration

CODE	SEGMENT PARA PUBLIC 'CODE'
	ASSUME	CS:CODE

;Entry point to Uc function
Uc	PROC	FAR
	push	bp
	mov	bp,sp

	mov	bx,DS			;save caller's DS
	cld

	lds	si,[bp.straddr]		;target string
	les	di,[bp.strptr]		;ptr to temporary string buffer
	lodsb				;get string length
	stosb				;stuff as output str length
	or	al,al			;if string text is null
	jz	Exit			; then exit

	xor	ah,ah			;clear msb
	mov	cx,ax			;loop counter
	mov	dx,2061H		;DL='a',DH=20H
L1:	lodsb				;next char
	cmp	al,dl
	jb	S1			;already uppercase
	 sub	al,dh			;uppercase it
S1:	stosb				;stuff uppercased char
	loop	L1

Exit:	mov	DS,bx			;restore caller's DS
	mov	sp,bp			;recover last stack psn
	pop	bp			;recover BP
	ret	PARAMSIZE		;return

Uc	ENDP

CODE	ENDS
	END	Uc
