; Original TASM code written by Tran
; Ported to NASM by Ike (a.k.a. Ivan Tomac)

%include "pmode.inc"

global  _initvga50
global  _vgatextptr
global  _textstakptr
global  _vgadefcolorz

SCRX            equ     80                    ; 80 or 90 columns wide
DEFTEXTSB       equ     0b8000h+(50*SCRX)*2

crtc90colregs   dw      0e11h,2d13h,6b00h,5901h,5a02h,5e04h

_textstakptr    dd      0       ; ptr to video stack, MUST set this first
_vgatextptr     dd      0       ; text vidmem adjusted base pointer
_vgadefcolorz   db      0,0,0,0,0,42,0,42,0,0,42,42,42,0,0,42
                db      0,42,42,21,0,42,42,42,21,21,21,21,21,63,21,63
                db      21,21,63,63,63,21,21,63,21,63,63,63,21,63,63,63

;
; Init VGA 50 line text mode and set color numbers
;
_initvga50:
        push eax
        push dx
        push esi
        @rlp eax,0b8000h
        mov [_vgatextptr],eax
        @rlp eax,DEFTEXTSB
        mov [_textstakptr],eax
        mov dword [eax],0
        mov WORD [v86r_ax],3
        mov al,10h
        int 33h
        mov WORD [v86r_ax],1102h
        mov BYTE [v86r_bl],0
        int 33h
        mov WORD [v86r_ax],1003h
        int 33h
        mov dx,3d4h
        mov ax,709h
        out dx,ax
        mov dx,3dah
        in al,dx
        test al,8
        jz short $-3
        mov dx,3c0h
        xor ah,ah
initvga50l1:
        mov al,ah
        out dx,al
        jmp short $+2
        out dx,al
        inc ah
        cmp ah,10h
        jb initvga50l1
        mov al,20h
        out dx,al
        mov dx,3dah
        in al,dx
        mov esi,_vgadefcolorz
        mov dx,3c8h
        xor al,al
        out dx,al
        inc dx
initvga50l2:
        lodsb
        out dx,al
        cmp esi,_vgadefcolorz+30h
        jb initvga50l2
%if SCRX == 90
        mov dx,3c4h
        mov ax,101h
        out dx,ax
        mov dl,0d4h
        mov esi,crtc90colregs
        outsw
        outsw
        outsw
        outsw
        outsw
        outsw
%endif
        pop esi
        pop dx
        pop eax
        ret

global  _putstr

;
; Put ASCIIZ string to screen
; In:
;   AH - attribute
;   BL - X
;   BH - Y
;   EDX -> ASCIIZ string
;

_putstr:
        push ax
        push esi
        push edi
        movzx edi,bh
        imul edi,SCRX*2
        movzx si,bl
        shl si,1
        add di,si
        add edi,[_vgatextptr]
        mov esi,edx
putstrl0:
        lodsb
        or al,al
        jz short putstrd
        stosw
        jmp putstrl0
putstrd:
        pop edi
        pop esi
        pop ax
        ret

global  _pushtext
global  _poptext

;
; Save an area of the screen to video stack
; In:
;   BL - X
;   BH - Y
;   CL - delta X
;   CH - delta Y
;

_pushtext:
        pushad
        mov ebp,[_textstakptr]
        mov word [ds:ebp+4],bx
        mov word [ds:ebp+6],cx
        lea edi,[ebp+8]
        movzx esi,bh
        imul esi,SCRX*2
        movzx eax,bl
        lea esi,[esi+eax*2]
        add esi,[_vgatextptr]
        movzx edx,cl
        lea ebx,[edx*2-SCRX*2]
        mov al,ch
pushtextl0:
        mov ecx,edx
        rep movsw
        sub esi,ebx
        dec al
        jnz pushtextl0
        mov [edi],ebp
        mov [_textstakptr],edi
        popad
        ret

;
; Restore last pushed area of the screen from video stack
;

_poptext:
        pushad
        mov ebp,[_textstakptr]
        mov eax,[ds:ebp]
        or eax,eax
        jz short poptextdone
        mov ebp,eax
        lea esi,[ebp+8]
        movzx edi,BYTE [ds:ebp+5]
        imul edi,SCRX*2
        movzx eax,BYTE [ds:ebp+4]
        lea edi,[edi+eax*2]
        add edi,[_vgatextptr]
        movzx edx,BYTE [ds:ebp+6]
        lea ebx,[edx*2-SCRX*2]
        movzx eax,BYTE [ds:ebp+7]
poptextl0:
        mov ecx,edx
        rep movsw
        sub edi,ebx
        dec eax
        jnz poptextl0
poptextdone:
        mov [_textstakptr],ebp
        popad
        ret

global  _textbox0

;
; Put box filled with character to screen
; In:
;   AL - character to fill with
;   AH - attribute
;   BL - X
;   BH - Y
;   CL - delta X
;   CH - delta Y
;

_textbox0:
        pushad
        movzx ebp,ch
        movzx edx,cl
        movzx edi,bh
        imul edi,SCRX*2
        movzx ebx,bl
        shl ebx,1
        add edi,ebx
        add edi,[_vgatextptr]
        lea esi,[edx*2-SCRX*2]
textbox0l0:
        mov ecx,edx
        rep stosw
        sub edi,esi
        dec ebp
        jnz textbox0l0
        popad
        ret

global  _textbox1

;
; Put outlined box to screen
; In:
;   AH - attribute
;   BL - X
;   BH - Y
;   CL - delta X
;   CH - delta Y
;   EDX -> outlining characters in the following order 'ĳڿf'
;

_textbox1:
        pushad
        movzx edi,bh
        imul edi,SCRX*2
        movzx ebx,bl
        lea edi,[edi+ebx*2]
        add edi,[_vgatextptr]
        lea ebx,[ecx-202h]
        movzx ebp,bl
        movzx esi,cl
        lea esi,[esi*2-SCRX*2]
        mov al,[edx+2]
        stosw
        mov al,[edx]
        mov ecx,ebp
        rep stosw
        mov al,[edx+3]
        stosw
        sub edi,esi
textbox1l0:
        mov al,[edx+1]
        stosw
        mov al,[edx+6]
        mov ecx,ebp
        rep stosw
        mov al,[edx+1]
        stosw
        sub edi,esi
        dec bh
        jnz textbox1l0
        mov al,[edx+4]
        stosw
        mov al,[edx]
        mov ecx,ebp
        rep stosw
        mov al,[edx+5]
        stosw
        popad
        ret

global  _setchars

;
; Set a group of character bitmaps
; In:
;   AL - first ASCII character to set
;   BL - number of bytes (lines) per character
;   CL - number of characters to set minus 1
;   EDX -> bitmap data for characters
; Notes:
;   Remember that in 80 column mode, character column 9 will be the same as
;    column 8 only for characters 0c0h-0dfh, in all other characters column 9
;    will be empty.
;

_setchars:
        push ax
        push ecx
        push edx
        push esi
        push edi
        mov esi,edx
        movzx edi,al
        shl edi,5
        add edi,0b8000h
        sub edi,[_code32a]
        mov dx,3c4h
        mov ax,00402h
        out dx,ax
        mov ax,00604h
        out dx,ax
        mov dx,3ceh
        mov ax,00c06h
        out dx,ax
        mov al,cl
        movzx edx,bl
        dec dl
        xor dl,1fh
setcharsl0:
        movzx ecx,bl
        rep movsb
        add edi,edx
        sub al,1
        jnc setcharsl0
        mov dx,3c4h
        mov ax,00302h
        out dx,ax
        mov ax,00204h
        out dx,ax
        mov dx,3ceh
        mov ax,00e06h
        out dx,ax
        pop edi
        pop esi
        pop edx
        pop ecx
        pop ax
        ret
