; This program is made by Daniel Horchner.
; email: dbjh@gmx.net
;
; This is an example that shows that an INT instruction in V86 mode doesn't
; generate exception 13 if the DPL of that int is 3. Note that the ISR
; executes in protected mode.

segment code32 public align=16 use32

%include "raw32.inc"

;32-bit data
%define SWAT            0

TSS1dsc         seg_descriptor  2067h,0,0, 89h,
TSS1            TSS
                times   2000h db 0      ; 1 bit for each port; 64K / 8 = 8K
TSS1sel         dw      0

org_exc13       dd      0               ; offset and selector of original
                dw      0               ;  exception 13 handler
org_tr          dw      0               ; original Task Register contents

msg0            db      'Not running at Privilege Level 0.','$'
msg1            db      'Message from ISR at Privilege Level 0.',0
msg2            db      'Message from exception 13 handler.',0
msg3            db      'Press a key to continue.',0

%ifdef  SWAT
org_arbyte      db      0               ; original access rights byte exc 13
%endif

;32-bit code
main:
                                        ; First, check if running at PL 0
        mov ebx,cs
        lar ecx,ebx
        and ecx,6000h                   ; Only the DPL bits are needed
        jz short .PL0
        mov edx,msg0
        call dosprint
        jmp exit
.PL0:
;
        str [org_tr]                    ; Save original Task Register

        mov cx,1                        ; Allocate 1 descriptor for TSS
        call getdsc
        jc near @exit
        mov [TSS1sel],ax

        mov eax,[code32a]
        add eax,TSS1
        mov [TSS1dsc.base0_15],ax
        shr eax,16
        mov [TSS1dsc.base16_23],al
        mov [TSS1dsc.base24_31],ah

        mov es,[data32sel]
        mov edi,TSS1dsc
        mov bx,[TSS1sel]                ; bx=selector
        call setdsc
        jc near @exit

        cli
        ltr [TSS1sel]
;
        mov bl,RMCALL_VECT+1
        mov cx,[code32sel]
        mov edx,PL0isr
        call setvect
        jc near @exit
        sub esp,6                       ; Set int gate's DPL to 3 -> possible
        sidt [esp]                      ;  to call int from PL 3
        mov edi,[esp+2]
        add esp,6
        or byte [gs:edi+(RMCALL_VECT+1)*8+5],3 << 5

        mov bl,13
        call getvect
        mov [org_exc13+4],cx            ; cx:edx=addr of exception handler
        mov [org_exc13],edx

        mov cx,cs                       ; Install V86 monitor
        mov edx,V86monitor
        call setvect
        jc near @exit
%ifdef  SWAT
        mov al,[gs:edi+13*8+5]          ; Get access rights byte...
        mov [org_arbyte],al             ; ...and save it
        mov al,8eh                      ; int gate, DPL 0, present
        mov [gs:edi+13*8+5],al          ; Set access rights byte
%endif

        push ds
        push es
        push fs
        push gs
        mov [TSS1.ss0],ss               ; Save protected mode ss:esp in Task
        mov [TSS1.esp0],esp             ;  State Segment -> V86 monitor uses 
                                        ;  current stack
                                        ; Build stack frame for entering V86 
        push dword [v86r_gs]            ;  mode: gs,
        push dword [v86r_fs]            ;  fs,
        push dword [v86r_ds]            ;  ds,
        push dword [v86r_es]            ;  es,
        push dword v86code              ;  ss,
        push dword v86stackbase         ;  esp,
        pushfd                          ;  eflags,
        or dword [esp],20000h           ; Set virtual 8086 mode flag
        push dword v86code              ;  cs,
        push dword v86start             ;  eip
        iretd                           ; VM bit in eflags on stack is set ->
retfromV86:                             ;  get eip, cs, eflags, esp, ss, es,
        pop gs                          ;  ds, fs, gs from stack -> V86 mode
        pop fs
        pop es
        pop ds

        mov bl,13
        mov cx,[org_exc13+4]            ; cx:edx=addr of exception handler
        mov edx,[org_exc13]
        call setvect
%ifdef  SWAT
        sub esp,6
        sidt [esp]
        mov ebx,[esp+2]
        add esp,6
        mov al,[org_arbyte]             ; Get original access rights byte...
        mov [gs:ebx+13*8+5],al          ; ...and restore it
%endif

@exit:
        sub esp,6
        sgdt [esp]
        mov eax,[esp+2]
        add esp,6
        movzx ebx,word [org_tr]
        and ebx,~ 3                     ; ebx=offset of TSS dsc in GDT
        and byte [gs:eax+ebx+5],~ 2     ; Clear Busy bit
        ltr [org_tr]                    ; Restore original Task Register
        sti

        mov esi,msg3
        @rlp edi,0b8000h+3*160
        mov bl,1fh
        call putstr
        mov byte [v86r_ah],0            ; ah=0 -> Wait for key and read char
        mov al,16h
        int RMCALL_VECT
        jmp exit                        ; Return to real/V86 mode

;
V86monitor:                             ; General protection
        add esp,10*4                    ; exc in V86 -> gs,fs,ds,es,ss,esp,
        mov ds,[cs:data32sel]           ;  eflags,cs,eip,error code on stack
        mov es,[cs:data32sel]
        mov esi,msg2
        @rlp edi,0b8000h+2*160
        mov bl,1fh
        call putstr
        jmp retfromV86

;
PL0isr:
        mov eax,cr0                     ; Exception 13 if this is PL > 0 code
        mov ds,[cs:data32sel]
        mov es,[cs:data32sel]
        mov esi,msg1
        @rlp edi,0b8000h+1*160
        mov bl,1fh
        call putstr
        iretd

segment v86code public align=16 use16

;16-bit data
v86stack        resb    100             ; V86 mode stack
v86stackbase:

v86msg          db      'Message from Virtual 8086 mode.'
v86msglen       equ     $-v86msg

;16-bit code
v86start:
        mov ax,cs
        mov ds,ax
        mov si,v86msg
        mov ax,0b800h
        mov es,ax
        mov di,0
        mov cx,v86msglen
        mov ah,1fh
.putchar:
        lodsb
        stosw
        loop .putchar

        int RMCALL_VECT+1               ; Call protected mode int

        int RMCALL_VECT                 ; int in V86 with DPL < 3 -> exc 13
