	page 60, 132
	title	PRINT - A String Printing Procedure
	name	PRINT
comment 
	PRINT							V1.00
==========================================================================
NAME
	PRINT - A String Printing Procedure

SYNOPSIS
	mov	ax, seg STRING		; only if STRING not in DS segment
	mov	ds, ax
	mov	dx, offset STRING
	call	PRINT

DESCRIPTION
       This procedure prints the passed ASCIIZ string, DS:DX, to stdout.

CAUTION
	Must be ASCIIZ string.

RETURNS
	Nothing.

PROGRAMMING NOTES
	Assembled with Microsoft MASM V6.11a

REGISTER USAGE
	Small Data Memory Models:
	AX, BX, CX, DX, and DI.

	Additional registers used in Large Data Memory Models:
	ES.  ES register is preserved.

MEMORY UTILIZATION
	DATA
		None
	CODE
					8086	80286+
		Small Code Model:		   20
		Large Code model:		   26

	STACK
		Small Code Model:		    4
		Large Code model:		    6

EXTERNAL LIBRARIES
	None
	
EXTERNAL PROCEDURES
	None

INTERUPTS CALLED
	Int 21h Function 40h - Write File or Device

GLOBAL NAMES
	PRINT

AUTHOR
	Raymond Moon - 6 Oct 95

	Copyright (c) 1995 - Raymond Moon
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	-  6 Oct 95	- Orginal
==========================================================================
	 Commend End

;----------------------------
; A	Make the small memory model the default.

ifndef	memmod
memmod	equ	<small>
endif

;----------------------------
; B	Specify processor, memory model, language and ES register assume.

	include procesor.inc			; Specify target processor
%	.model memmod, fortran
	assume es:DGROUP

;=========================================================================
;	CODE
;=========================================================================
; C	Start Code Segment and define PRINT procedure

	.CODE

Print	proc

;----------------------------
; D	If large data models, save ES and set ES to DS

if	@DataSize
	push	es			; Save ES
	mov	ax, ds			; AX = DS
	mov	es, ax			; ES = DS
endif

;----------------------------
; E	DS:DX => ASCIIZ string to print.  Need to determine the size.

	mov	cx, -1			; Set CX to -1
	xor	al, al			; AL = Null
	mov	di, dx			; DI => string start
	repne	scasb			; Continue until Null found
	not	cx			; Convert CX to string length + 1
	dec	cx			; CX = length

;----------------------------
; F	Display string to screen

	mov	ah, 40h
	mov	bx, 1
	int	21h

;----------------------------
; G	Restore ES if required

if	@DataSize
	pop	es			; Restore ES
endif

;----------------------------
; H	Return

	ret
Print	endp
	end
