	page 60,132
	title	STACK CHECK - A Stack Overflow Checking Procedure
	name	STACK_CHECK
comment 
	STACK_CHECK						V1.00
==========================================================================
NAME
	STACK_CHECK

SYNOPSIS
ifdef	DEBUG
	call	Stack_Check
endif

DESCRIPTION
	This procedure checks to ensure that the SP register is not
	within 32 bytes of STACK_BOTTOM.  This will give room for DOS
	to save registers and other information.

	So that stack checking is down only during debugging, use conditional
	assembly as shown in SYNOPSIS.	Then stack checking occurs only
	when DEBUG is defined.

CAUTIONS
	DS => DGROUP upon entry

RETURNS
	Nothing

PROGRAMMING NOTES
	Normal used when debugging.  Use conditional assembly to include
	a call to this procedure right after the procedure declaration
	and any local variables declaration.

	Assembled using MASM 6.11d.  Written to link with any memory model.

REGISTER USAGE
	All memory models:
	ax, or ax, bx, cx and dx (depends on execution path).

	All registers saved.

MEMORY REQUIREMENTS
	(in bytes)     Tiny   Small  Compact   Medium	Large	Huge
	Code:		 32	32	 32	  32	  32	 32
	_Data:		  0	 0	  0	   0	   0	  0
	Const:		 16	16	 16	  16	  16	 16
	_BBS:		  0	 0	  0	   0	   0	  0
	Stack:		 10	10	 10	  12	  12	 12

	Stack best occurs when there is not any stack overflow.  Worst occurs
	when there is a stack overflow.

EXTERNAL LIBRARIES
	None

EXTERNAL PROCEDURES
	None

INTERRUPTS CALLED
	Int 21h Function 40h - Write File or Device

GLOBAL NAMES
	Stack_Check

AUTHOR
	Raymond Moon - 15 Apr 95
	Copyright (c) 1995, MoonWare
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	- 15 Apr 95	- Orginal

==========================================================================
	 Comment End
	
;-----------------------------
; A	Make the small memory model the default

ifndef	memmod
memmod	equ	<small>
endif

;-----------------------------
; B	Include the processor, memory model, associate ES register with
;	DGROUP, and specify DOS segment order.

	include procesor.inc
%	.MODEL	memmod,FORTRAN
	assume	es:DGROUP

;-----------------------------
; C	Include files

	include startup.inc

;----------------------------
; D	Required Defines

SAFETY_MARGIN	equ	32
BELL		equ	 7
STDERR		equ	 2

;=========================================================================
;	DATA
;=========================================================================
; E	Declare any required data

	.CONST

ERROR_MSG	db	BELL, 'Stack Overflow', BELL

;=========================================================================
;	CODE
;=========================================================================
; F	Start CODE segment and define STACK_CHECK procedure

	.CODE

Stack_Check	proc

;----------------------------
; G	Save AX.  AX = Stack bottom plus Safety Margin.  If SP is below,
;	that is defined as a stack overflow.

	push	ax			; Save AX
	mov	ax, STACK_BOTTOM	; AX = STACK_BOTTOM
	add	ax, SAFETY_MARGIN	; AX = STACK_BOTTOM + SAFETY_MARGIN
	cmp	ax, sp			; Is SP below that threshold?
	jb	SC1			; No, skip warning message

;----------------------------
; H	Stack Overflow.  Save all used registers.

	push	dx			; Save DX
	push	cx			; Save CX
	push	bx			; Save BX

;----------------------------
; I	Display error message.

	mov	dx, OFFSET ERROR_MSG	; DX => ERROR_MSG
	mov	cx, sizeof ERROR_MSG	; CX = length of ERROR_MSG
	mov	bx, 2			; Display to STDERR
	mov	ah, 40h 		; Write File or Device
	int	21h			; Call DOS

;----------------------------
; J	Restore all used registers.

	pop	bx			; Restore BX
	pop	cx			; Restore CX
	pop	dx			; Restore DX

;----------------------------
; I	Return.  Restoring AX register.

SC1:	pop	ax			; Restore AX
	ret				; Return

Stack_Check	endp
	end
