;
; *** Listing 13-10 ***
;
; Finds the first occurrence of the letter 'z' in
; a zero-terminated string, with a less-than-ideal
; conditional jump followed by an unconditional jump at
; the end of the loop.
;
	jmp	Skip
;
TestString	label	byte
	db	'This is a test string that is '
	db	'z'
	db	'terminated with a zero byte...',0
;
; Finds the first occurrence of the specified byte in the
; specified zero-terminated string.
;
; Input:
;	AL = byte to find
;	DS:SI = zero-terminated string to search
;
; Output:
;	SI = pointer to first occurrence of byte in string,
;		or 0 if the byte wasn't found
;
; Registers altered: AX, SI
;
; Direction flag cleared
;
; Note: Do not pass a string that starts at offset 0 (SI=0),
;	since a match on the first byte and failure to find
;	the byte would be indistinguishable.
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
FindCharInString:
	mov	ah,al	;we'll need AL since that's the
			; only register LODSB can use
	cld
FindCharInStringLoop:
	lodsb		;get the next string byte
	cmp	al,ah	;is this the byte we're
			; looking for?
	jz	FindCharInStringFound
			;yes, so we're done with a match
	and	al,al	;is this the terminating zero?
	jz	FindCharInStringNotFound
			;yes, so we're done with no match
	jmp	FindCharInStringLoop
			;check the next byte
FindCharInStringFound:
	dec	si	;point back to the matching byte
	ret
FindCharInStringNotFound:
	sub	si,si	;we didn't find a match, so return
			; 0 in SI
	ret
;
Skip:
	call	ZTimerOn
	mov	al,'z'		;byte value to find
	mov	si,offset TestString
				;string to search
	call	FindCharInString ;search for the byte
	call	ZTimerOff
