/*************************************************************************

	dr_sysv.c       Directory (dr) subroutines
			for Bywater Software.

			Implementation for AT&T Unix System V (tm)

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "stdio.h"
#ifdef	__STDC__
#include "process.h"
#endif
#include "string.h"
#include "time.h"
#include "sys/types.h"
#include "sys/stat.h"

#include "dr.h"

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#ifndef	CR
#define	CR	13
#define	LF	10
#endif

int	dr_fs = '/';
char	dr_all[ MAX_PATHLENGTH ] = "*";

extern char *tmpname();

char tmpfname[80], command_string[80];
FILE *unix_fp;
static char      _path[ MAX_PATHLENGTH ];

dr_first( findb, retb )
	char findb[]; 
	struct dir_ent *retb;
	{
	register int c;
	char *name;

	strcpy( tmpfname, "/tmp/dr_unix.tmp" );
	sprintf( command_string, "ls -a %s | sort > %s", findb, tmpfname );
	system( command_string );

	if ( ( unix_fp = fopen( tmpfname, "r" )) == NULL) 
		{
		bw_error( "Cannot open temporary file for directory");
		return FALSE;
		}

	if ( feof( unix_fp ))
		{
		fclose( unix_fp );
#ifdef OLD_DEBUG
		fprintf( "Temporary file is empty. \n" );
#else
		unlink( tmpfname ); 
#endif
		return FALSE;
		}
	else
		{

		strcpy( _path, findb );
		c = strlen( _path );

		while (( c >= 0 ) && ( _path[ c ] != dr_fs ))
			{
#ifdef  OLD_DEBUG
			fprintf( stderr, "_path: %s c: %d\n", _path,
				c );
#endif
			_path[ c ] = 0;
			--c;
			}

		strcpy( retb->pathname, _path );

		name = fgets( command_string, 80, unix_fp );
		if ( fill_buffer( retb, name ) == FALSE )
			{
			return FALSE;
			}
		else
			{
			return TRUE;
			}
		}
	}

dr_next( retb )
	struct dir_ent *retb;
	{
	char *name;

	if ( feof( unix_fp ) )
		{
		fclose( unix_fp );
#ifndef	DEBUG
		unlink( tmpfname ); 
#endif
		return FALSE;
		}
	else
		{
		strcpy( retb->pathname, _path );
		name = fgets( command_string, 80, unix_fp );
		if ( fill_buffer( retb, name )== FALSE )
			{
			return FALSE;
			}
		else
			{
			return TRUE;
			}
		}
	}

fill_buffer( retb, name )
	struct dir_ent *retb;
	char *name;
	{
	static struct stat s_buf;

#ifdef OLD_DEBUG
	fprintf( stderr, "fill_buffer() received filename: <%s> \n", name );
#endif

	strcpy( retb->filename, name );
	unix_truncate( retb->filename );

	if ( strlen( retb->filename ) == 0 )
		{
#ifdef OLD_DEBUG
		fprintf( stderr, "Null filename returned. \n" );
#endif
		return FALSE;
		}

	stat( retb->filename, &s_buf );

	retb->size = s_buf.st_size;

	if ( ( s_buf.st_mode & 0040000 ) == 0040000 )
		{
		retb->type = FILE_DIRECTORY;
		}
	else if ( ( s_buf.st_mode & 0000400 ) == 0000007 )
		{
		retb->type = FILE_EXECUTABLE;
		}
	else if ( ( s_buf.st_mode & 0000200 ) == 0000070 )
		{
		retb->type = FILE_EXECUTABLE;
		}
	else if ( ( s_buf.st_mode & 0000100 ) == 0000100 )
		{
		retb->type = FILE_EXECUTABLE;
		}
	else
		{
		retb->type = FILE_NORMAL;
		}

	return TRUE;

	}

unix_truncate( buffer )
	char *buffer;
	{
	register char *p;

	p = buffer;
	while( *p != 0 )
		{
		if (( *p == CR ) || ( *p == LF ))
			{
			*p = 0;
			}
		++p;
		}
	}

