/*************************************************************************

	kb_sysv.c	Keyboard (KB) Subroutines
			for Bywater Software

			Implementation for Unix SYSTEM V

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "stdio.h"
#include "fcntl.h"
#include "signal.h"
#include "sys/stat.h"
#include "termio.h"

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

struct termio old_ttystruct;
int	kb_tty;			/* fd for new terminal file */

#ifdef	KB_TEST
main()
	{
	register int s;
	static char tbuf[ 3 ];

	kb_init();

	tbuf[ 0 ] = 0;
	while ( tbuf[ 0 ] != 0x1b )
		{
		s = read( kb_tty, tbuf, 1 );
		printf( "The read() function returned %d \n", s );
		if ( s > 0 )
			{
			printf( "The key is <%c> \n", tbuf[ 0 ] );
			}
		}

	kb_deinit();
	}
#endif

/*************************************************************************

	FUNCTION:       kb_init()

	DESCRIPTION:    This function should perform any initialization
			necessary for the keyboard system.

	INPUT:          none.

	RETURNS:        none.

**************************************************************************/

kb_init()
	{
	struct termio new_ttystruct;

	if ( ioctl( 0, TCGETA, &old_ttystruct ) < 0 )  
		{
		fprintf( stderr, "Failed to get old tty parameters. \n" );
		}

	if ( ( kb_tty = open( "/dev/tty", O_NDELAY)) == -1 )
		{
		fprintf( stderr, "Failed to open /dev/tty \n" );
		}
#ifdef	DEBUG
	else
		{
		fprintf( stderr, "/dev/tty returns %d \n", kb_tty );
		}
#endif

	if ( ioctl( kb_tty, TCGETA, &new_ttystruct ) < 0 )  
		{
		fprintf( stderr, "Failed to get new tty parameters. \n" );
		}

	new_ttystruct.c_cc[4] = 0;		/* minimum characters */
	new_ttystruct.c_cc[5] = 0;		/* maximum time */
	new_ttystruct.c_iflag = 0;
	new_ttystruct.c_lflag = ISIG;
	new_ttystruct.c_cflag &= ~CSIZE;
	new_ttystruct.c_cflag |= CS8;
	new_ttystruct.c_cflag &= ~PARENB;
	if ( ioctl( kb_tty, TCSETA, &new_ttystruct ) < 0 )  
		{
		fprintf( stderr, "Failed to set new tty parameters. \n" );
		}

	}



/*************************************************************************

	FUNCTION:       kb_deinit()

	DESCRIPTION:    This function should perform any necessary
			deinitialization, that is, return the keyboard
			to its default state when a Simple Software
			program is to be exited.

	INPUT:          none.

	RETURNS:        none.

**************************************************************************/

kb_deinit()
	{
	if ( ioctl( 0, TCSETA, &old_ttystruct ) < 0 )
		{
		fprintf( stderr, "Failed to restore old tty parameters. \n");
		}
	}

/*************************************************************************

	FUNCTION:       kb_rxstat()

	DESCRIPTION:    This function determines whether a character is
			ready from the console.  The function is used
			especially in telecommunications programs,
			where it is necessary to poll the keyboard
			without locking up the program waiting for a
			response.

	INPUT:          none.

	RETURNS:        The function returns 0 if no character is
			available and 1 if a character is available.

**************************************************************************/

int kb_available = 0;
int kb_hold = 0;

kb_rxstat()
	{
	register int s;
	static char tbuf[3];

	if ( kb_available == TRUE )
		{
		return TRUE;
		}
	else
		{
		s = read( kb_tty, tbuf, 1 );
		if ( s == FALSE )
			{
			kb_available = FALSE;
			return FALSE;
			}
		else
			{
			kb_hold = tbuf[ 0 ];
			kb_available = TRUE;
			return TRUE;
			}
		}
	}

/*************************************************************************

	FUNCTION:       kb_rx()

	DESCRIPTION:    This function returns a single character from
			the keyboard.  If a character is not available
			it waits.  The function should be able to
			recognize any special keys, and return the
			appropriate Simple Software KB conventions
			designated for them.

	INPUT:          none.

	RETURNS:        The function returns the ASCII code for the
			key pressed, or the Simple Software KB convention
			(see kb.h) for a function or other special key.

**************************************************************************/

kb_rx()
	{

	while( kb_rxstat() == FALSE )
		{
		;
		}

	kb_available = FALSE;
	return kb_hold;
	}


