'
'============================================================================
'      DO NOT MAKE CHANGES IN THIS MEMBER
'============================================================================

'      Definitions for TYPE and DECLARE statements necessary to call
'       following assembly language routines found in QB.QLB:
'       ABSOLUTE, INTERRUPT, INTERRUPTX, INT86OLD, and INT86XOLD.

'      If you include this member in your source code, then you do not
'       need to include QB.BI from the QB45 directory
'       (or QBX.BI from the BC7 directory).

'
'***************************************************************************
'
' type needed for INTERRUPT
'
TYPE RegType
	 ax    AS INTEGER
	 bx    AS INTEGER
	 cx    AS INTEGER
	 dx    AS INTEGER
	 bp    AS INTEGER
	 si    AS INTEGER
	 di    AS INTEGER
	 flags AS INTEGER
END TYPE

'
' type needed for INTERUPTX
'
TYPE RegTypeX
	 ax    AS INTEGER
	 bx    AS INTEGER
	 cx    AS INTEGER
	 dx    AS INTEGER
	 bp    AS INTEGER
	 si    AS INTEGER
	 di    AS INTEGER
	 flags AS INTEGER
	 ds    AS INTEGER
	 es    AS INTEGER
END TYPE
'
'                 DECLARE statements for the 5 routines in QB.QLB
'                 -----------------------------------------------
'
' Generate a software interrupt, loading all but the segment registers
'
DECLARE SUB INTERRUPT (intnum AS INTEGER, inreg AS RegType, outreg AS RegType)

'
' Generate a software interrupt, loading all registers
'
DECLARE SUB INTERRUPTX (intnum AS INTEGER, inreg AS RegTypeX, outreg AS RegTypeX)

'
' Call a routine at an absolute address.
' NOTE: If the routine called takes parameters, then they will have to
'       be added to this declare statement before the parameter given.
'
DECLARE SUB ABSOLUTE (address AS INTEGER)

'
' Generate a software interrupt, loading all but the segment registers
'       (old version)
'
DECLARE SUB INT86OLD (intnum AS INTEGER, inarray() AS INTEGER, outarray() AS INTEGER)

'
' Gemerate a software interrupt, loading all the registers
'       (old version)
'
DECLARE SUB INT86XOLD (intnum AS INTEGER, inarray() AS INTEGER, outarray() AS INTEGER)


'
'===========================================================================
'
'  definition of DECLARE and COMMON statements used in LangWin
'
'===========================================================================

' used in FIndFirst & FindNext routines
TYPE DataTransferArea
	Reserved1   AS STRING * 21
	Attribute   AS STRING * 1
	FileTime    AS INTEGER
	FileDate    AS INTEGER
	FileSize    AS LONG
	FileName    AS STRING * 13
END TYPE

' routines for windows
DECLARE SUB BlinkOff ()
DECLARE SUB GetMaxRows (MRows%)
DECLARE SUB GetDispMode (Cols%, VPage%, Dmode%)
DECLARE FUNCTION CloseWindow% ()
DECLARE SUB ReadChar (APage%, AttrChar%)
DECLARE SUB PhysScrollUp (Lines%, Attrib%, SRow%, SCol%, ERow%, ECol%)
DECLARE SUB PhysScrollDown (Lines%, Attrib%, SRow%, SCol%, ERow%, ECol%)
DECLARE FUNCTION BlankWin% (SRow%, SCol%, ERow%, ECol%, WColr%, BColr%, BType%, TColr%, CIcon%, ModeSw%)
DECLARE FUNCTION OpenScrollWindow% (SRow%, SCol%, ERow%, ECol%, WColr%, BColr%, BType%, TColr%, Text$(), STRow%, STCol%, ETRow%, ETCol%, CloseIcon%, ModeSw%)
DECLARE SUB ScrollWinUp (Switch%, Lines%)
DECLARE SUB ScrollWinDown (Switch%, Lines%)
DECLARE FUNCTION WinEvent% (WinAction%)
DECLARE SUB SetColor (foreground%, background%)
DECLARE FUNCTION ShowTitle% (Title$, foreground%, background%)
DECLARE FUNCTION MakeHorizLine% (Row%, LinType%)
DECLARE FUNCTION MakeVertLine% (Col%, LinType%)
DECLARE FUNCTION MakePushButton% (Row%, Col%, Length%, ButtonText AS STRING, Foreg%, Backg%, Shadow%)
DECLARE SUB ShowPushButton (Handle%)
DECLARE FUNCTION ShowWinText% (Row%, Col%, Foreg%, Text AS STRING)
DECLARE FUNCTION MakeInputField% (Row%, Col%, Length%, FieldText AS STRING, Foreg%, Backg%)
DECLARE FUNCTION GetInputField% (Handle%)
DECLARE FUNCTION MakeCheckBox% (Row%, Col%, Foreg%, Backg%, Default$)
DECLARE FUNCTION NextButtonFocus% (Dir%)
DECLARE SUB HitPushButton (Han%)
DECLARE SUB HitCheckBox (Han%)
DECLARE FUNCTION GetVerNum$ ()
DECLARE SUB ChangeButtonFocus (Handle%, Switch%)
DECLARE SUB LangWinInit ()
DECLARE FUNCTION MakeBox% (StartBoxRow%, StartBoxCol%, EndBoxRow%, EndBoxCol%, BoxLinType%, BoxColor%)
DECLARE SUB ReShowInputField (Handle%)
DECLARE SUB ReShowText ()
DECLARE SUB ReShowPage ()
DECLARE SUB NewFocusWindow (ClickedWinHan%)
DECLARE FUNCTION IsWinOpen (wn%, wh%)
DECLARE FUNCTION ActivateButton% (ButtonHandle%, FocusSw%)
DECLARE FUNCTION DeactivateButton% (ButtonHandle%, FocusSw%)
DECLARE SUB RefreshScrollText (Text$())
DECLARE SUB ReShowTitle (Handle%)
DECLARE FUNCTION GrowScrollText% (Text AS STRING)


' routines for mouse
DECLARE SUB SetTextCursor (Smask%, Cmask%)           ' function 0Ah
DECLARE SUB SetXLimit (MinX%, MaxX%)                 ' function 08h
DECLARE SUB SetYLimit (MinY%, MaxY%)                 ' function 07h
DECLARE SUB SetMousePos (Horiz%, Vert%)              ' function 04h
DECLARE SUB GetMousePos (Buttons%, Horiz%, Vert%)    ' function 03h
DECLARE SUB HideMouseCursor ()                       ' function 02h
DECLARE SUB ShowMouseCursor ()                       ' function 01h
DECLARE FUNCTION InitMouse% (NumButtons%)            ' function 00h
DECLARE FUNCTION MouseExists% ()
DECLARE SUB GetButtonPress (Buttons%, Count%, Horiz%, Vert%) ' function 05h

' routines for directories, drives, and files
DECLARE FUNCTION GetFileNames% (sw%, filespec$, Text$())
DECLARE FUNCTION FindFirst% (Attr%, FileName$, DTA AS DataTransferArea)
DECLARE FUNCTION FindNext% (DTA AS DataTransferArea)
DECLARE FUNCTION GetCurDir$ (DriveLetter$)
DECLARE FUNCTION ChangeDir% (PathName$)
DECLARE FUNCTION GetCurDrive$ ()
DECLARE FUNCTION ChangeDrive% (DriveLetter$)


' misc routines
DECLARE SUB WaitTicks (TicksToWait%)
DECLARE SUB GetXtenErr ()  ' int &h21, function &h59 - extended dos error

CONST FALSE = 0, TRUE = NOT FALSE


' global variables
COMMON SHARED InRegs AS RegTypeX, OutRegs AS RegTypeX
COMMON SHARED WinParms(), SaveWin(), MovWin(), Sav1()
COMMON SHARED SaveText() AS STRING, WinNum(), WinStack(), ScreenMap()
COMMON SHARED SaveTextSlots()
COMMON SHARED CurWinNum, LastWinStack
COMMON SHARED CurWinPtr, MaxWindows, MaxRows, MaxCols, BlinkBitOff
COMMON SHARED MaxBakColor, MaxForColor, HaveMouse, MaxTextLines, MaxTextWins
COMMON SHARED XPixlChar, YPixlChar
COMMON SHARED DefaultSmask, DefaultCmask
COMMON SHARED RHend, LHend
COMMON SHARED MaxButtons
COMMON SHARED ButtonsText() AS STRING
COMMON SHARED ButtonsData()
COMMON SHARED Uarrow, Darrow, Closeit
COMMON SHARED ScrollShadeChar, ScrollBlockChar, ScrollSliderPress
COMMON SHARED CheckOn AS STRING, CheckOff AS STRING
COMMON SHARED UserHotKeys(), AboutVis, AllowMove, AnyWinOpen
COMMON SHARED tracer, VidOff

