
'  -- CRC32.BAS --
'
'  This program is donated to the Public
'  Domain by MarshallSoft Computing, Inc.
'  It is provided as an example of the use
'  of the Personal Communications Library.
'
$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL OFF     'turn off all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFDWD A-Z

$INCLUDE "CRC32.BI"

DIM Crc32Table(256) AS SHARED DWORD
DIM Crc32POLY       AS SHARED DWORD
DIM FACTOR          AS SHARED DWORD
DIM Init32Flag      AS SHARED INTEGER

' calculates the 32 bit Crc using the byte method

FUNCTION Crc32Byte(BYVAL Crc AS DWORD, BYVAL octet AS BYTE) PRIVATE AS DWORD

DIM J AS INTEGER

 ' XOR data byte with high byte of accumulator
 Crc = (Crc XOR octet) AND &H00FF
 FOR J = 0 TO 7
    IF (Crc AND 1) THEN
       SHIFT RIGHT Crc, 1
       Crc = Crc XOR Crc32POLY
    ELSE
       SHIFT RIGHT Crc,1
    END IF
 NEXT J
 Crc32Byte = Crc

END FUNCTION

' initialize CRC table

SUB Init32Crc() PRIVATE

  DIM I AS INTEGER

  Init32Flag = 1                        'only need to do this once
  Crc32POLY = &HEDB88320
  FACTOR = &H00FFFFFF

  FOR I = 0 TO 255
    Crc32Table(I) = Crc32Byte(0,I)
  NEXT I

  PRINT "CRC-32 Table Built"

END SUB

' Fetch CRC table entry

FUNCTION FetchCrc32(BYVAL Index AS BYTE) PUBLIC AS DWORD
IF Init32Flag = 0 THEN
    CALL Init32Crc
END IF
FetchCrc32 = Crc32Table(Index)
END FUNCTION

' compute updated CRC

FUNCTION UpdateCrc32(BYVAL Octet AS BYTE, _
                     BYVAL Crc   AS DWORD) PUBLIC AS DWORD
  DIM RightShifted AS DWORD
  DIM Index AS Integer

  IF Init32Flag = 0 THEN
    CALL Init32Crc
  END IF

  'compute CRC
  RightShifted = Crc
  SHIFT RIGHT RightShifted,8
  Index = &H00FF AND (Crc XOR Octet)
  UpdateCrc32 = Crc32Table(Index) XOR (RightShifted AND FACTOR)
  'Crc32Table[(unsigned char)(Crc ^ (long)(Octet))] ^ ((Crc >> 8) & 0x00FFFFFF);
END FUNCTION

           