{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'funs.int'}
{$include: 'fs_pkg.int'}
{$include: 'database.int'}
{$include: 'load.int'}
{$include: 'script2a.int'}

IMPLEMENTATION OF script2a;

USES types,globals,utils,funs,fs_pkg,database,load;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

var
  doseqq [EXTERN]: word;

function kmatch(consts pat,info : lstring) : boolean;
var
  i,j,k : integer;
  patty,cappy : lstring(screen_cols);
begin
  if pat.len=0 then [kmatch:=true; return];
  kmatch:=false;
  if info.len=0 then return;
  ucs(info,cappy);
  i:=1; j:=ord(pat.len)+1;
  while i<=ord(pat.len) do begin
    if pat[i]=' ' then [i:=i+1; cycle];
    j:=i+scaneq(ord(pat.len)-i,' ',pat,i);
    if j>=ord(pat.len) then [j:=ord(pat.len)+1; break];
    patty.len:=wrd(j-i);
    movesl(ads pat[i],ads patty[1],patty.len);
    k:=positn(patty,cappy,1);
    if k=0
      then return
      else cappy[k]:='x'; {this forbids duplicate key matches}
    i:=j+1; j:=ord(pat.len)+1;
  end {while};
  patty.len:=wrd(j-i);
  movesl(ads pat[i],ads patty[1],patty.len);
  if positn(patty,cappy,1)=0 then return;
  kmatch:=true;
end {kmatch};

procedure bbs2a{consts s : lstring; var str : lstring};
var
  i,j,k : integer;
  next_state : task;
  p,p2,p3 : para;
  i4 : integer4;
  fl : boolean;
begin
  next_state:=succ(q[wx].state);
  case q[wx].state of
  delete_old:
    if s=null then
      next_state:=q[wx].return_state
    else if number_query(s,1,MAXINT,q[wx].count) then
      q[wx].index:=0
    else
      [display(bad_userid_txt); next_state:=q[wx].return_state];
  delete_old2:
    [q[wx].index:=q[wx].index+1;
     if q[wx].index<=largest_member_number then
       [if disk2u(q[wx].index) then
          [i4:=date2jd(w^[wx].date_of_call) -
               date2jd(q[wx].your.last_called_date);
           if ord(i4)>=q[wx].count
             then prompt_with(user_delete_txt)
             else next_state:=delete_old2]
        else
          next_state:=delete_old2]
     else
       next_state:=q[wx].return_state];
  delete_old3:
    if nagree(s) then
      [q[wx].your.active:=' ';
       i:=on_line(q[wx].index);
       if i>=0 then
         [w^[i].state:=stopping; q[i].my.active[1]:=' ']
       else
         dbp_member(q[wx].index,q[wx].your);
       mbx(mailpath,q[wx].your.userid,str); mail_delete(str);
       mbx(biopath,q[wx].your.userid,str); mail_delete(str);
       number_of_members:=number_of_members-1;
       display(user_deleted_txt); next_state:=delete_old2]
    else
      next_state:=delete_old2;
  change_level:
    if s=null then
      next_state:=q[wx].return_state
    else if number_query(s,1,largest_member_number,i) then
      [if disk2u(i)
         then prompt_with(enter_level_txt)
         else [display(bad_userid_txt); next_state:=q[wx].return_state]]
    else
      [display(bad_userid_txt); next_state:=q[wx].return_state];
  change_level2:
    if number_query(s,0,9,j) then
      [q[wx].your.userlevel[1]:=chr(ord('0')+j);
       i:=on_line(ivalue(q[wx].your.userid)); q[wx].index:=j;
       if i>=0 then
         [q[i].level:=j; q[i].my.userlevel[1]:=chr(ord('0')+j);
	  notify(i,new_level_txt)]
       else
         dbp_member(ivalue(q[wx].your.userid),q[wx].your);
       display(level_changed_txt); next_state:=q[wx].return_state]
    else
      [display(bad_level_txt); next_state:=q[wx].return_state];
  change_mbx:
    [next_state:=q[wx].return_state;
     if s<>null then
       [if number_query(s,1,largest_member_number,i) then
          [if disk2u(i) then
	     [q[wx].index:=ivalue(q[wx].your.mbx_max);
	      prompt_with(mbx_size_txt); next_state:=change_mbx2]
	   else
	     display(bad_userid_txt)]
        else
          display(bad_userid_txt)]];
  change_mbx2:
    [next_state:=q[wx].return_state;
     if number_query(s,0,999,q[wx].index) and then
        encode(str,q[wx].index:3) then
       [kopystr(str,q[wx].your.mbx_max);
        i:=on_line(ivalue(q[wx].your.userid));
        if i>=0
          then kopystr(str,q[i].my.mbx_max)
          else dbp_member(ivalue(q[wx].your.userid),q[wx].your);
        display(size_changed_txt)]
     else
       display(bad_size_txt)];
  kill_line:
    if number_query(s,0,number_of_lines,q[wx].index) and then
       w^[q[wx].index].active then
      prompt_with(line_kill_txt)
    else
      [display(bad_line_txt); next_state:=main_menu];
  kill_line2:
    [next_state:=main_menu;
     if agree(s) then
       [if w^[q[wx].index].state=going then
	  [w^[q[wx].index].state:=stopping;
	   i:=w^[q[wx].index].chat;
	   if i>=0 then w^[i].chat:=-1;
	   w^[q[wx].index].chat:=-1;
	   display(line_killed_txt)]
	else if q[wx].index>0 then {modem line}
	  [select_port(q[wx].index); dtr_off;
	   if wx>0 then select_port(wx);
           w^[q[wx].index].reset_count:=0;
	   if w^[q[wx].index].talking_to = cls
	     then w^[q[wx].index].talking_to:=modem
	     else w^[q[wx].index].talking_to:=SUCC(w^[q[wx].index].talking_to);
	   display(line_killed_txt)]]];
  recycle:
    if number_query(s,1,largest_member_number,q[wx].index) then
      [last_new_user:=q[wx].index-1;
       display(good_recycle_txt); next_state:=main_menu]
    else
      [display(bad_recycle_txt); next_state:=main_menu];
  reset_time:
    [next_state:=q[wx].return_state;
     if s<>null then
       [if number_query(s,1,largest_member_number,i) and then disk2u(i)
          then [prompt_with(reset_really_txt); next_state:=reset_time2]
          else display(bad_userid_txt)]];
  reset_time2:
    [fl:=false; next_state:=q[wx].return_state;
     if agree(s) then
       [copystr('0',q[wx].your.minutes_today); fl:=true];
     if fl then  
       [i:=ivalue(q[wx].your.userid);
	j:=on_line(i);
	if j>=0 then
	  [w^[j].connect_sec0:=jt; q[j].minutes_on:=0;
	   copystr('0',q[j].my.minutes_today); q[j].minutes_2day:=0]
	else
	  dbp_member(i,q[wx].your);
	display(time_reset_txt)]];
  unans1:
    if s=null then
      next_state:=main_menu
    else if number_query(s,1,largest_member_number,i) then
      [if disk2u(i)
         then prompt_with(enter_multiple_txt)
         else [display(bad_userid_txt); next_state:=main_menu]]
    else
      [display(bad_userid_txt); next_state:=main_menu];
  unans2:
    if number_query(s,1,number_of_qaires,j) then
      [for k:=1 to number_of_answers do q[wx].your.mult_answer[j][k]:=' ';
       if j=1 then q[wx].your.mult_answer[1][1]:='Z';
       i:=on_line(ivalue(q[wx].your.userid)); q[wx].index:=j;
       if i>=0 then
         [for k:=1 to number_of_answers do q[i].my.mult_answer[j][k]:=' ';
          if j=1 then q[i].my.mult_answer[1][1]:='Z']
       else
         dbp_member(ivalue(q[wx].your.userid),q[wx].your);
       display(qaire_cleared_txt); next_state:=main_menu]
    else
      [display(bad_multiple_txt); next_state:=main_menu];
  down1:
    [if number_query(s,1,1440,i) then
       [doseqq:=1; shut_down(i)];
     next_state:=main_menu];
  answer:
    [if q[wx].level>=priv_bio
       then display(reans_essay_txt);
     q[wx].qr:=1];
  answer2:
    [if qair[q[wx].qr]<>nil and then
        ((q[wx].level=9) or (q[wx].my.mult_answer[q[wx].qr][1]<>' '))
       then display(reans_mult_txt);
     q[wx].qr:=q[wx].qr+1;
     if q[wx].qr<=number_of_qaires then next_state:=answer2];
  answer3:
    prompt_with(arrow_txt);
  answer4:
    [if str=null or else str[1]=mn[14][2] {Q} then
       next_state:=main_menu
     else if str[1]=mn[14][3] {M} then
       [display(qaire_header_txt); next_state:=questionnaire]
     else if str[1]=mn[14][4] {E} then
       [if q[wx].level>=priv_bio then
          [if essay<>nil then
             [q[wx].return_state:=main_menu;
              display(bio_header_txt); next_state:=bio]
           else
             next_state:=main_menu]
        else
          [display(read_access_txt); next_state:=main_menu]]
     else if str[1]=mn[14][5] {1} then
       q[wx].qr:=1
     else if str[1]=mn[14][6] {2} then
       q[wx].qr:=2
     else if str[1]=mn[14][7] {3} then
       q[wx].qr:=3
     else if str[1]=mn[14][8] {4} then
       q[wx].qr:=4
     else if str[1]=mn[14][9] {5} then
       q[wx].qr:=5
     else
       [display(answer_again_txt); next_state:=answer]];
  answer5:
    [q[wx].qs:=qair[q[wx].qr];
     if q[wx].qs<>nil and then
        ((q[wx].level=9) or (q[wx].my.mult_answer[q[wx].qr][1]<>' ')) then
       [q[wx].index:=1; q[wx].return_state:=main_menu;
        display(nextq_txt); next_state:=mult_ch1a]
     else
       [prompt_with(answer_again_txt); next_state:=answer]];
  browse_prompt:
    if time_check(true) then
      [display(time_limit_txt); next_state:=snip]
    else
      prompt_with(file_number_txt);
  browse:
    [make_number(s,str);
     if number_query(str,1,largest_member_number,i) then
       [if disk2u(i)
          then display(browse_txt)
          else [display(bad_userid_txt); next_state:=q[wx].return_state]]
     else if s=null or else str[1]=mn[8][3] {Q} then
       next_state:=q[wx].return_state
     else
       [display(bad_userid_txt); next_state:=q[wx].return_state]];
  browse_qs1: prompt_with(want_questions_txt);
  browse_qs2:
    [if str=null or else str[1]=mn[8][3] {Q} then
       next_state:=q[wx].return_state
     else if str[1]=mn[1][1] {Y} then
       q[wx].bflag:=true {show questions and answers}
     else if str[1]=mn[1][2] {N} then
       q[wx].bflag:=false {just show the answers}
     else
       [prompt_with(want_questions_txt); next_state:=browse_qs2];
     q[wx].qr:=1; q[wx].qs:=qair[q[wx].qr]; q[wx].bindex:=0];
  browse_qs3:
    if q[wx].qs=nil then
      [while true do {loop until live ?-aire or done}
         [q[wx].qr:=q[wx].qr+1;
          if q[wx].qr>number_of_qaires then
            [mbx(biopath,q[wx].your.userid,str);
             if fs_openr(wx,str)=0 then
               prompt_with(see_biogs_txt)
             else
               [fs_close(wx); next_state:=q[wx].return_state];
             break]
          else if ((q[wx].level=9) or
	  	   (q[wx].my.mult_answer[q[wx].qr][1]<>' ')) and then
                  (q[wx].your.mult_answer[q[wx].qr][1]<>' ') and then
                  (qair[q[wx].qr]<>nil) then
            [q[wx].qs:=qair[q[wx].qr]; q[wx].bindex:=0;
             next_state:=browse_qs3; break]]]
    else
      [p:=newpara(null); w^[wx].output:=p; p2:=p;
       if q[wx].bflag then
         [p:=q[wx].qs^.qna;
          while p<>nill and then p^.msg.len>3 and then p^.msg[1]<>' ' do
           [p3:=newpara(p^.msg);
            p2^.link:=p3; p2:=p3; p:=p^.link]];
       if q[wx].qs^.kind=mult then
	 for i:=1 to q[wx].qs^.nans do
	   [p3:=get_answer(q[wx].your.mult_answer[q[wx].qr][q[wx].bindex+i],
			   q[wx].qs^.qna);
	    if p3=nill then break;
	    p2^.link:=p3; p2:=p3]
       else
         [p3:=newpara(null); p3^.msg.len:=wrd(q[wx].qs^.nans);
 	  for i:=1 to q[wx].qs^.nans do
            p3^.msg[i]:=q[wx].your.mult_answer[q[wx].qr][q[wx].bindex+i];
          p2^.link:=p3];
       q[wx].bindex:=q[wx].bindex+q[wx].qs^.nans; q[wx].qs:=q[wx].qs^.link;
       w^[wx].crud:=true; w^[wx].node_type:=nt_display;
       next_state:=browse_qs3];
  browse_biogs:
    if agree(s) then
      [q[wx].bflag:=false; {don't allow & codes in essay answers!}
       next_state:=display_file]
    else
      [fs_close(wx); next_state:=q[wx].return_state];
  goodbye_menu:
      if closing_target>0 and then q[wx].level>=priv_cl
        then prompt_with(goodbye_menu_txt)
        else next_state:=snip;
  goodbye:
    if str=null or else str[1]=mn[1][2] {N} then
      next_state:=snip
    else if str[1]=mn[1][1] {Y} then
      [q[wx].holding:=false; q[wx].flag:=true; {not canned}
       disparas(q[wx].msg_first); {discard any held message}
       q[wx].msg_last:=nill; q[wx].msg_ptr:=nill;
       q[wx].correspondent:=closing_target;
       if disk2u(closing_target) then
         [i:=ivalue(q[wx].your.mbx_count);
          j:=ivalue(q[wx].your.mbx_max);
          if i<max_max_mbx and then ((i<j) or (q[wx].level=9)) then
	    [q[wx].return_state:=snip; q[wx].cleanup:='I';
             prepare_header;
	     prompt_with(enter_subject_txt); next_state:=enter_subject]
          else
	    [display(no_slots_txt); next_state:=snip]]
       else
         [display(bad_userid_txt); next_state:=snip]]
    else if str[1]=mn[8][4] {M} and then q[wx].flag then
      next_state:=main_menu
    else
      [prompt_with(goodbye_menu_txt); next_state:=goodbye];
  db1: {select a new category}
    prompt_with(dbc_txt);
  db2: {process db category}
    if time_check(true) then
      [display(time_limit_txt); next_state:=snip]
    else if str=null then
      next_state:=main_menu
    else if str[1]=mn[9][1] {?} or else
            ((str.len=1) and (str[1]=mn[9][2])) {L} or else
            eq(str,ss[40]) {HELP} then
      [kopylst(path_db,str); konkat(str,'\'); konkat(str,ss[51]); {MENU}
       if fs_openr(wx,str)=0 then
         [q[wx].return_state:=db1; q[wx].bflag:=true;
          next_state:=display_file]
       else
         [fs_close(wx); next_state:=db1]]
    else if str.len=1 and then str[1]=mn[9][3] {S} then
      [prompt_with(which_subdir_txt); next_state:=db2]
    else
      [copylst(path_db,q[wx].pathname);
       konkat(q[wx].pathname,'\'); konkat(q[wx].pathname,str);
       if (not filename_ok(str)) or else (not exist_dir(q[wx].pathname))
         then [display(dbb_txt); next_state:=db1]];
  db3: {display info about particular database}
    [copylst(q[wx].pathname,str); konkat(str,'\'); konkat(str,ss[51]); {MENU}
     if fs_openr(wx,str)=0 then
       [q[wx].return_state:=db3a; q[wx].bflag:=true; next_state:=display_file]
     else
       fs_close(wx)];
  db3a: prompt_with(dbk_txt); {ask for search key}
  db4: {process search key}
    if time_check(true) then
      [display(time_limit_txt); next_state:=snip]
    else if str=null then
      next_state:=db1
    else if str[1]=mn[8][1] {?} or else eq(str,ss[40]) {HELP} then
      next_state:=db3
    else if q[wx].level<priv_db then
      [display(read_access_txt); next_state:=db3a]
    else
      [if q[wx].qa=nill then q[wx].qa:=newpara(null);
       stripx(str,q[wx].qa^.msg);
       if ord(q[wx].qa^.msg.len)<min_db and then q[wx].level<9 then
         [display(shortxt); next_state:=db3a]
       else
         [copylst(q[wx].pathname,str); concat(str,'\HEADER');
          if fs_openr(wx,str)=0 then
            [q[wx].return_state:=db4a; q[wx].bflag:=true;
	     next_state:=display_file]
          else
            fs_close(wx)]];
  db4a: {open database}
    [copylst(q[wx].pathname,str); concat(str,'\DATA');
     if fs_openr(wx,str)=0 then
       [q[wx].count:=0; q[wx].index:=0; q[wx].count4:=0;
        if q[wx].xstr=nill
          then q[wx].xstr:=newpara(null)
          else q[wx].xstr^.msg:=null;
        q[wx].return_state:=db6]
     else
       [fs_close(wx);
        display(dbb_txt); next_state:=db1]];
  db5: {search the database, displaying matching lines}
    [q[wx].index:=q[wx].index+1;
     if q[wx].index<5 then {don't hog the disk}
       next_state:=db5
     else
       [q[wx].count:=q[wx].count+1;
        if (not fs_eof(wx)) and then fs_gets(wx,q[wx].xstr^.msg)=0 then
          [next_state:=db5; q[wx].index:=0;
           if kmatch(q[wx].qa^.msg,q[wx].xstr^.msg) then 
             [q[wx].count4:=q[wx].count4+1;
	      expand_tabs(q[wx].xstr^.msg); display(q[wx].xstr)]]
        else
          [fs_close(wx); display(dbm_txt)]]];
  db6: {prompt for additional information}
    [copylst(q[wx].pathname,str); concat(str,'\*.TXT');
     if q[wx].count4>0 and then exist_wild(str)
       then prompt_with(moretxt)
       else next_state:=db3a];
  db7: {provide additional information - display .txt file}
    if str=null then
      next_state:=db3a
    else if filename_ok(str) then
      [copylst(q[wx].pathname,str); concat(str,'\'); konkat(str,s);
       konkat(str,'.TXT'); q[wx].count:=0;
       i:=fs_openr(wx,str);
       if i=0 then
         [q[wx].return_state:=db6; q[wx].bflag:=false;
          q[wx].count4:=0; next_state:=display_file]
       else
         [fs_close(wx); q[wx].count:=i;
          display(dbx_txt); next_state:=db6]]
    else
      [display(dbx_txt); next_state:=db6];
  display_file: {bflag means expand & codes}
    if fs_eof(wx) then
      [fs_close(wx); next_state:=q[wx].return_state]
    else
      [p:=newpara(null); q[wx].count:=fs_gets(wx,p^.msg);
       if q[wx].count=0 then
         [expand_tabs(p^.msg); init_fx;
          if q[wx].bflag and then (not substitute(p^.msg)) then
            [kopylst(p^.msg,str); eval(substitute(str));
             kopylst(str,p^.msg)];
          w^[wx].output:=p; w^[wx].crud:=true;
          q[wx].count4:=q[wx].count4+ord(w^[wx].output^.msg[0])+2;
          w^[wx].node_type:=nt_display; next_state:=display_file]
       else
         [dispara(p); fs_close(wx);
          display(io_error_txt); next_state:=q[wx].return_state]];
  end {case};
  q[wx].state:=next_state;
end {bbs2a};

END.
