/*
 *  Activate.c (v1.01)
 *
 *  MS-DOS / TURBO C++ specific routines for accessing 1st sector of HD
 *
 */


/*
 *  Reads in Cyl 0, Side 0, Sector 1 from each physical hard disk into
 *  buffer (global variable) and extracts partition table info from the
 *  sector (partn tbl starts at 0x1BE, 4 entries of 0x10 bytes plus a 2
 *  byte signature at end. Returns 0 if read OK, non-zero otherwise.
 *
 */

int read_partition_table(partn, drive)
partition_table *partn;
int drive;
{
  int status;

  status = biosdisk(_DISK_READ, drive, 0, 0, 1, 1, buffer);
  memmove(partn, (buffer + 0x1BE), sizeof(partition_table));
  return status;
}


/*
 *  Does the reverse of read_partition_table() - writes a new partition
 *  table into the relevent bit of buffer (the last 74 bytes) and writes
 *  the whole 512 bytes to the 1st sector of the specified Hard Drive
 *
 */


int write_partition_table(partn, drive)
partition_table partn;
int drive;
{
  int status;

  memmove((buffer + 0x1BE), &partn, sizeof(partition_table));
  status = biosdisk(_DISK_WRITE, drive, 0, 0, 1, 1, buffer);
  return status;
}


/*
 * Determines how many Hard drives the BIOS is aware of by trying to read
 * the Master Boot sector of each Hard drive starting from 0x80 (1st disk)
 * contines to read drives (0x81, 0x82, etc) until it receives an error,
 * after which it assumes that all physical drives have been read.
 *
 * Returns number of drives which it has detected.
 *
 */

int determine_number_of_drives()
{
  int drive = 0x80;

  while(!biosdisk(_DISK_READ, drive++, 0, 0, 1, 1, NULL));
  return drive - 0x81;
}
