#define LISTSIZE  100			/* define constant */
typedef int       numlist[LISTSIZE];	/* define data type */

int	lmax(numlist list, int count);	/* declare functions */
void	swap(int *i, int *j);
void	lsort(numlist list, int count);
void	dumplist(numlist list, int count);

main()					/* main function of program */
{
   numlist	list;			/* declare array */
   int		count,i;		/* declare variables */

   count = 0;
   do {					/* get value from 1 to 100 */
      printf("Enter # of items (1..%d):  ",LISTSIZE);
      scanf("%d",&count);
   } while (count < 1 && count > LISTSIZE);

   for (i=0; i<count; i++)		/* initialize array with */
      list[i] = rand();			/* random values	 */

   lsort(list,count);			/* sort array 		 */
   dumplist(list,count);		/* print array on screen */
   i = lmax(list,count);		/* get max value in array*/
   printf("The maximum value in the list is %d\n",i);
   return(0);
}

int lmax(numlist list, int count)    /* return max value in array */
{
   int	i,max;

   max = list[0];
   for (i=1; i<count; i++)
      if (list[i] > max)
	 max = list[i];
   return(max);
}

void swap(int *i, int *j)		/* swap two integer values */
{
   int	temp;

   temp = *i; *i = *j; *j = temp;
}

                   /* sort array in ascending order: */
void lsort(numlist list, int count)
{
   int top,k,min;

   for (top=0; top < count-1; top++) {
      min = top;
      for (k = top+1; k < count; k++)
	 if (list[k] < list[min])
	    min = k;
      if (min != top)
	 swap(&list[top],&list[min]);
   }
}

void dumplist(numlist list, int count)	/* print array on screen */
{
   int	i;

   for (i=0; i<count; i++)
     printf("%8d",list[i]);
   printf("\n");
}

