/*
** The Window BOSS's Data Clerk
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
** wn_iemsg - field input error message handler 
**
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "windows.h"                    /* standard stuff */

/*
************
* wn_ihmsg *
************
*/

/*
** wn_iemsg(msg)
**
**    (char *)   msg - pointer to message to be displayed.
**
** RETURNS:
**
**    NULL if error, else TRUE
**
** NOTES:
**
**  This routine should be modified or replaced with code to suit
**  your the applications specific needs.  It hooks to wn_g????
**  such that whenever the field validation fails wn_g???? calls wn_iemsg
**  to display an error message for the field in question.  The hooks
**  in wn_g????? are of the form:
**
**      if(validation failed) wn_iemsg(msg);
**
**  This routine displays a single line of text on the last line and
**  waits for a key to be struck before returning to accept new data
**  for the field in question.
**
**  The error message can be a maximum of 80 characters, and must
**  not contain any formatting directives (\n\t...).
**
**  Some wn_g???? (i.e. wn_gtext) have no provision to vaildate
**  data and therefore never attempt to call this routine.
**  
*/

/*
************
* wn_iemsg *
************
*/

wn_iemsg(msg)                           /* field input error message */
char *msg;                              /* the message to display */
{
WINDOWPTR wn;                           /* a window for me */

  if(!strlen(msg)) return(TRUE);        /* no message - just return */
  if(strlen(msg) > 80) return(NULL);    /* dont be foolish */
  wn=wn_open(1000,(wni_mxrows-1),0,(int)strlen(msg),1,(RVIDEO),NVIDEO);
  if(!wn) return(NULL);                 /* Huh??? */
  wn_puts(wn,0,0,msg);                  /* display message */
  v_getch();                            /* fetch response */
  wn_close(wn);                         /* make message go away */
  return(TRUE);                         /* all done */
}

/* End */
