/*****************************************************************************

             Program: timer.c

             Function: an ms-dos equivalent to the unix time command,
                       measures length of time required to run a program
                       or execute a command.

             Syntax: timer -c <dos internal command>
                     timer -c <batch job>
                     timer <filename.ext>

             Language: written in DeSmet C ver 2.41

*****************************************************************************/

#include "stdio.h"

extern unsigned _rax, _rbx, _rcx, _rdx;

main(argc,argv)
int argc;
char *argv[];
{
   int i,start[8],stop[8],error=0;
   int hours,minutes,seconds,hundreths;
   int cmdflag;
   char str[20],startstring[60],stopstring[60],command[20],commandtail[80];

   if(strcmp(argv[1],"-c")==0 || strcmp(argv[1],"/c")==0)
      cmdflag=1;
   else
      cmdflag=0;

   if(argc<2+cmdflag) {
      printf("\ntimer measures the amount of time required for a command to execute.\n\n");
      printf("syntax: timer <filename.ext> or\n");
      printf("        timer -c <dos internal command> or\n");
      printf("        timer -c <batch job>\n\n");
      printf("where filename is the name of an executable program,\n");
      printf("dos internal command is an INTERNAL DOS command (ie. dir), and\n");
      printf("batch job is the name of a batch file (ie. autoexec).\n\n");
      printf("timer will not work properly for times greater than 24 hours.\n");
      exit(1);
   }

   if(cmdflag) {
      strcpy(command,"COMMAND.COM");
      strcpy(commandtail, "/C");
      }
   else {
      strcpy(command,argv[1]);
      strcpy(commandtail, "" );
   }

   for(i=2;i<argc;i++) {
      strcat(commandtail,argv[i]);
      strcat(commandtail," ");
   }

   printf("Executing %s %s\n", command, commandtail );

   datetime(start);                        /* get start time info */
   error=exec(command, commandtail);       /* execute */
   datetime(stop);                         /* get stop time info   */

   if(error==-1){
      printf("\nerror: file not found or illegal command.\n");
      printf("       use the -c flag to time an internal dos command or a batch file.\n");
      printf("       'COMMAND.COM' must be in the default drive when using -c flag.\n\n");
      exit(1);
     }
   else
      if(error!=0)
         printf("\nreturned ERRORLEVEL code = %d\n",error);

   strcpy(startstring,"\n  Start: ");

      sprintf(str,"%2d-%2d-%4d", start[6], start[7], start[5]);
      fillzero(str);
      strcat( strcat(startstring,str), " ");

      sprintf(str,"%2d:%2d:%2d.%2d", start[1], start[2], start[3], start[4]);
      fillzero(str);
      strcat( strcat(startstring,str), "\n");

   strcpy(stopstring,"  Stop:  ");

      sprintf(str,"%2d-%2d-%4d", stop[6], stop[7], stop[5]);
      fillzero(str);
      strcat( strcat(stopstring,str), " ");

      sprintf(str,"%2d:%2d:%2d.%2d", stop[1], stop[2], stop[3], stop[4]);
      fillzero(str);
      strcat( strcat(stopstring,str), "\n");

   printf("\n[%s %s]\n", command, commandtail );
   puts(startstring);
   puts(stopstring);

   hours    =stop[1]-start[1];
   minutes  =stop[2]-start[2];
   seconds  =stop[3]-start[3];
   hundreths=stop[4]-start[4];

   if(hundreths<0){
      hundreths+=100;
      seconds--;
   }
   if(seconds<0)  {
      seconds+=60;
      minutes--;
   }
   if(minutes<0)  {
      minutes+=60;
      hours--;
   }
   if(hours<0)
      hours+=24;

   printf("\nElapsed time: %d hours, %d minutes, %d.%d seconds.\n",hours,minutes,seconds,hundreths);

}

int datetime(ar) /* was declared void */
int *ar[];
{
   _rax=(44 << 8);   _doint( 0x21 );                 /* get time */
   *++ar= _rcx >> 8;                 /* hour  */
   *++ar= _rcx & 0x00ff;             /* minute*/
   *++ar= _rdx >> 8;                 /* second*/
   *++ar= _rdx & 0x00ff;             /* 1/100 */

   _rax=(42 << 8);   _doint( 0x21 );                 /* get date */
   *++ar= _rcx;                      /* year  */
   *++ar= _rdx >> 8;                 /* month */
   *++ar= _rdx & 0x00ff;             /* day   */
}

int fillzero(st) /* was declared void */
char *st;
{
   char *tc;

   for(tc=st;*tc!='\0';tc++)
       *tc= *tc==' ' ? '0' : *tc;
}
