/*
**  C S R O R D E R . C
**
**  CSR Electronic Order and User Response Form.
**
**  Copyright 1988 Bob Pritchett, New Dimension Software.
**
**  History:
**
**  07/01/88  Registration and mailing list forms added.
**
**  06/11/88  Created and work begun.
**
*/

#include "color.h"
#include "skey.h"
#include "csrmisc.h"

#define VERSION "3.0"			/* Version Number String */

#define INTRO	0
#define SURVEY	1
#define REGIS	2
#define PRINT	3
#define THANKS	4
#define MAX	5

#define MAXSUR	9

extern int _csrclr;			/* Make CSR Global Color Available */

void newline(void);			/* Forward Declaration */
void waitkey(void);			/* Forward Declaration */
void text(int); 			/* Forward Declaration */
void nameaddr(void);			/* Forward Declaration */
void finddate(void);			/* Forward Declaration */
void info();				/* Forward Declaration */
void survey();				/* Forward Declaration */
void registration();			/* Forward Declaration */
void mailing(); 			/* Forward Declaration */

static char name[40];			/* Name for Response Form */
static char title[40];			/* Title for Response Form */
static char company[40];		/* Company for Response Form */
static char address[40];		/* Address for Response Form */
static char city[40];			/* City for Response Form */
static char state[40];			/* State for Response Form */
static char zip[40];			/* Zip for Response Form */
static char phone[40];			/* Phone for Response Form */
static char compiler[20];		/* Compiler for Response Form */
static char drive[14];			/* Disk Drive for Response Form */

static char *sr[MAXSUR][80];		/* Survey Results for Response Form */
static char *survques[MAXSUR] = 	/* Survey Questions */
 {
  "Where did you obtain this copy of CSR?  (If from a BBS, please give #.)",
  "How do you use, or intend to use, CSR?",
  "What is the most useful part of the CSR package?",
  "What do you think of the CSR documentation?",
  "If you have seen it, what is your impression of the NDS News?",
  "What is your overall impression of CSR?",
  "Do you work with or plan to work with Microsoft Windows, and how?",
  "Do you work with or plan to work with OS/2 in the near future?",
  "Do you have any other comments?"
 };

static int dy;				/* Day */
static int mn;				/* Month */
static int yr;				/* Year */

static int w;				/* Work Window */

static int ts = 0;			/* Took Survey Flag */
static int bl;				/* Bottom Line Variable */
static int cl = 1;			/* Current Line Counter */

main()
 {
  int x;				/* Temporary Variable */
  int cur;				/* Original Cursor Position */
  cur = save_cursor();			/* Save Cursor Position */
  save_screen();			/* Save User's Screen */
  cls();				/* Clear Screen */
  color(WHT_F+RED_B);			/* Set CSR Global Colors */
  scroll(0,0,1,79,0,0,_csrclr); 	/* Clear First Two Lines */
  scroll(24,0,24,79,0,0,_csrclr);	/* Clear Last Line */
  /*
  **  The following three lines take advantage of the new ANSI C
  **  adjacent string concatenation and center the text with the
  **  most recently set global color.  This way the above color scheme
  **  can be changed without changing each reference.
  */
  ccenter(0,"C Spot Run v" VERSION ,_csrclr);
  ccenter(1,"User Registration Program",_csrclr);
  ccenter(24,"Copyright 1988 Bob Pritchett, New Dimension Software",_csrclr);
  color(WHT_F+BLU_B);			/* Set CSR Global Colors */
  w = wopen(2,0,23,79,0);		/* Open Borderless Work Window */
  bl = wrow(w)-1;			/* Store Bottom Line */
  wfreeze(w,1,bl);			/* Freeze Top and Bottom Lines */
  whome(w);				/* Home Cursor in Window */
  text(INTRO);				/* Display Introductory Text */
  waitkey();				/* Allow the User to Read the Text */
  nameaddr();				/* Get User's Name and Address */
  info();				/* Obtain Required Information */
  wprint(w,"  Would you please participate in a short survey?");
  x = wfinptynd(w,cl,50,1);		/* Query for Survey */
  newline();				/* Advance the Line Pointer */
  if ( x )				/* If Survey Desired */
     survey();				/* Survey Processing */
  finddate();				/* Check/Obtain Current Date */
  wprint(w,"  Would you like to register as a CSR user?");
  x = wfinptynd(w,cl,44,1);		/* Query for Registration */
  newline();				/* Advance the Line Pointer */
  if ( x )				/* If Registration Desired */
     registration();			/* Registration Processing */
  else					/* Otherwise */
     mailing(); 			/* Print Mailing List Application */
  text(THANKS); 			/* Display Final Text */
  waitkey();				/* Allow the User to Read the Text */
  wclose(w);				/* Close Work Window */
  restore_screen();			/* Restore the User's Screen */
  restore_cursor(cur);			/* Restore Original Cursor Position */
 }

void newline()				/* Advance the Line Count */
 {
  wprint(w,"\n");			/* Perform New Line */
  if ( cl < bl )			/* If Current Line Less Than Bottom */
     ++cl;				/* Increment Current Line Count */
 }

void waitkey()				/* Wait for a Keyhit */
 {
  int c;				/* Temporary Character Holder */
  wprint(w,"  -- Hit a Key --");	/* Print Message */
  c = getch();				/* Get a Character */
  if ( ! c )				/* If NULL */
     getch();				/* Get Second Code */
  newline();				/* Advance the Line Count */
 }

void text(x)				/* Text Output Routine */
 int x; 				/* ID of Text to Output */
 {
  int i = 0;				/* Temporary Counter */
  static char *info[MAX][16] =		/* Static Array of Text */
   {
    {
     "Thank you for your interest in C Spot Run.  This program is designed",
     "to help you register as a CSR user with a minimum of effort.  With",
     "this program you may order the source code and a usage license, register",
     "as a user, have your name placed on the NDS mailing list, participate",
     "in a survey, or simply comment on the package.",
     "",
     "You will be prompted with a number of questions to which you may respond",
     "by entering a text reply, using a fully editable input field, or by",
     "selecting one of several choices presented in a pop-up menu.",
     "",
     "First, we'll need your name and address.  When you are finished your",
     "input in the pop-up window hit the escape key to continue.",
     "*"
    },
    {
     "The following few questions were chosen to help us understand your",
     "opinion of CSR and to plan for future releases.  Please feel free to",
     "write on the printed form generated by this program if the single line",
     "input field is not enough.",
     "*"
    },
    {
     "Registration for C Spot Run can be done on three levels: Personal or",
     "Commercial Source Code License or simple Shareware Registration.",
     "",
     "A personal source code license entitles an individual to use the",
     "CSR source code for personal use and costs $50.  For $75 a commercial",
     "use license is available; purchase of this license is mandatory for",
     "CSR use in any for-profit setting.  In addition, a $15 registration",
     "option is available which entitles the user to update notifications",
     "but does not include the source code.",
     "",
     "Please select a registration level:",
     "*"
    },
    {
     "Please turn on your printer and line up the top of form.",
     "*"
    },
    {
     "Thank you for your support.  Please send your response form as soon",
     "as possible in order that we may process it quickly.",
     "*"
    }
   };
  if ( x >= MAX )			/* If No Text Available */
     return;				/* Return */
  while ( *info[x][i] != '*' )		/* While Text Remains */
   {
    wprintf(w,"  %s\n",info[x][i++]);	/* Print a Line */
    if ( cl < bl )			/* If Current Line Less Than Bottom */
       ++cl;				/* Increment Current Line Count */
   }
 }

void nameaddr() 			/* Input Name and Address */
 {
  int lw;
  int x = 0;
  int v;
  wcolor(WHT_F+RED_B,WHT_F+RED_B);
  wfcolor(BLK_F+WHT_B);
  lw = wopen(7,12,15,62,1);
  wtitle(lw," Name and Address ",1);
  wmessage(lw," ESC when Done ",0);
  wputat(lw,0,4,"Name:");
  wffill(lw,0,10,30);
  wputat(lw,1,3,"Title:");
  wffill(lw,1,10,25);
  wputat(lw,2,1,"Company:");
  wffill(lw,2,10,34);
  wputat(lw,3,1,"Address:");
  wffill(lw,3,10,30);
  wputat(lw,4,4,"City:");
  wffill(lw,4,10,30);
  wputat(lw,5,3,"State:");
  wffill(lw,5,10,2);
  wputat(lw,5,13,"Zip:");
  wffill(lw,5,18,10);
  wputat(lw,6,3,"Phone:");
  wffill(lw,6,10,14);
  while ( 1 )
   {
    switch ( x )
     {
      case 0: v = wfinptstred(lw,0,10,30,name,name);		break;
      case 1: v = wfinptstred(lw,1,10,25,title,title);		break;
      case 2: v = wfinptstred(lw,2,10,34,company,company);	break;
      case 3: v = wfinptstred(lw,3,10,30,address,address);	break;
      case 4: v = wfinptstred(lw,4,10,30,city,city);		break;
      case 5: v = wfinptstred(lw,5,10,2,state,state);		break;
      case 6: v = wfinptstred(lw,5,18,10,zip,zip);		break;
      case 7: v = wfinptstred(lw,6,10,14,phone,phone);		break;
     }
    switch ( v )
     {
      case UARROW: x = max(0,x-1);	break;
      case      1: 
      case DARROW: x = min(7,x+1);	break;
      case   PGUP:
      case   HOME: x = 0;		break;
      case   PGDN:
      case    END: x = 7;		break;
      case     27: x = 100;		break;
	  default: x = min(7,x+1);	break;
     }
    if ( x == 100 )
       break;
   }
  wclose(lw);
 }

void finddate() 			/* Check/Obtain Current Date */
 {
  char temp[80];			/* Temporary String */
  int x;				/* Temporary Variable */
  get_date(&dy,&mn,&yr);		/* Get System Date */
  yr -= 1900;				/* Get Two Digit Year */
  if ( yr > 87 )			/* If Possibly Accurate */
   {
    sprintf(temp,"  The system reports the current date as %02d/%02d/%02d."
	    ,mn,dy,yr);
    wprintf(w,temp);			/* Print Current Date */
    newline();				/* Advance the Line Counter */
    wprint(w,"  Is this correct?");	/* Prompt for Verification */
    x = wfinptynd(w,cl,19,1);		/* Verify Date */
    newline();				/* Advance the Line Counter */
    if ( x )				/* If Correct */
       return;				/* Return */
   }
  while ( 1 )				/* Loop Forever */
   {
    wprint(w,"  Please enter the correct date: (01/01/80)");
    wfinptstre(w,cl,44,8,temp); 	/* Input Date as String */
    newline();				/* Advance the Line Counter */
    sscanf(temp,"%d/%d/%d",&mn,&dy,&yr);    /* Process Date Entry */
    if ( chk_date(mn,dy,yr) )		/* If Date is Valid */
       break;				/* Break Out */
    wprint(w,"  The date you entered was invalid.");
    newline();				/* Advance the Line Counter */
   }
 }

void info()				/* Obtain Required Information */
 {
  int x;				/* Temporary Variable */
  int sc;				/* Saved Cursor Pointer */
  static char *temp[6] =		/* Menu Options */
   {
    "   MSC 5.x   ",
    " Quick C 1.x ",
    "   MSC 4.0   ",
    " Turbo C 1.5 ",
    " Turbo C 1.0 ",
    "    Other    "
   };
  static char *temp2[4] =		/* Second Menu Options */
   {
    " 1.2M 5.25\" ",
    " 360K 5.25\" ",
    "  1.4M 3.5\" ",
    "  720K 3.5\" "
   };
  wprint(w,"  Please select your primary compiler.");
  sc = save_cursor();			/* Save Cursor Position */
  mcolor(WHT_F+RED_B,RED_F+WHT_B);	/* Set Menu Colors */
  x = pop_menu(8,60,6,temp," Compilers ",1);	/* Get Menu Choice */
  restore_cursor(sc);			/* Restore Cursor Position */
  newline();				/* Advance the Line Counter */
  strtrm(temp[x],compiler);		/* Store Compiler Name */
  wprint(w,"  Please select your primary disk drive.");
  sc = save_cursor();			/* Save Cursor Position */
  x = pop_menu(9,60,4,temp2," Drive ",1);	/* Get Menu Choice */
  restore_cursor(sc);			/* Restore Cursor Position */
  newline();				/* Advance the Line Counter */
  strtrm(temp2[x],drive);		/* Store Drive Type */
 }

void survey()				/* Give a User Survey */
 {
  int i;				/* Temporary Variable */
  newline();				/* Advance the Line Counter */
  text(SURVEY); 			/* Display Text Regarding Survey */
  newline();				/* Advance the Line Counter */
  for ( i = 0; i < MAXSUR; ++i )	/* Loop Through Questions */
   {
    wprintf(w,"  %s",survques[i]);	/* Print Question */
    newline();				/* Advance the Line Counter */
    wfinptstre(w,cl,4,74,sr[i]);	/* Input String Result */
    newline();				/* Advance the Line Counter */
    newline();				/* Advance the Line Counter */
   }
  wprint(w,"  Thank you.");		/* Thank User for Survey */
  newline();				/* Advance the Line Counter */
  ts = 1;				/* Set Took Survey Flag */
 }

void registration()			/* Print Order Form for Registration */
 {
  int x;				/* Temporary Variable */
  int tmp;				/* Temporary Variable */
  char t1[80];				/* Temporary String */
  char t2[80];				/* Temporary String */
  static int amt[3] =			/* Dollar Amounts */
   {
    50, 75, 15
   };
  newline();				/* Advance the Line Counter */
  text(REGIS);				/* Display Registration Description */
  newline();				/* Advance the Line Counter */
  wprint(w,"    1) Personal  2) Commercial  3) Shareware:");
  wfinptintr(w,cl,46,2,&tmp,1,3);	/* Input Choice */
  newline();				/* Advance the Line Counter */
  wprint(w,"  Thank you.");		/* Thank User for Order */
  newline();				/* Advance the Line Counter */
  text(PRINT);				/* Have User Ready Printer */
  waitkey();				/* Wait for a Key */
  strcen("C Spot Run v" VERSION ,t1,78);/* Center String */
  strcen("Order Form",t2,78);		/* Center String */
  lprintf("\n\n %s\n %s\n\n\n",t1,t2);	/* Print Header */
  lprintf("\t\t\t\t\t\t\t\t%02d/%02d/%2d\n",mn,dy,yr);	/* Print Date */
  lprintf("\t%s, ",name);		/* Print User's Name */
  lprintf("%s\n",title);		/* Print User's Title */
  lprintf("\t%s\n",company);		/* Print User's Company */
  lprintf("\t%s\n",address);		/* Print User's Address */
  lprintf("\t%s, %s  %s\n",city,state,zip); /* Print User's City/State/ZIP */
  lprintf("\t%s\n\n",phone);		/* Print User's Phone */
  lprintf("\t%s - %s\n",compiler,drive);/* Print User's Configuration */
  if ( ts )				/* If User Took Survey */
   {
    lprint("\n    -- Survey Results\n");	/* Print Survey Header */
    for ( x = 0; x < MAXSUR; ++x )	/* Loop Through Survey */
     {
      lprintf("    %d> %s\n",x+1,survques[x]);	/* Print Survey Question */
      lprintf("         %s\n",sr[x]);		/* Print Survey Result */
     }
    lprint("\n");
   }
  else					/* Otherwise */
    for ( x = 0; x < MAXSUR+2 ; ++x )	/* Loop for Survey Lines */
	lprint("\n\n"); 		/* Print a Newline */
  lprint("\n\n\n\n\t\tPlease enclose a check or money order made out to\n");
  lprintf("\t\tNew Dimension Software for the amount of $%d.\n",amt[tmp-1]);
  lprint("\n\t\tAddress the envelope to:\n\n");
  lprint("\t\t\tNew Dimension Software\n");
  lprint("\t\t\t23 Pawtucket Dr.\n");
  lprint("\t\t\tCherry Hill, NJ  08003\n\n\n\n\n\n");
  lprint("\t    +--------------------  NDS USE ONLY  --------------------+\n");
  lprint("\t    |                                                        |\n");
  lprint("\t    |  Received:  ____ /____ /____   Sent: ____ /____ /____  |\n");
  lprint("\t    |                                                        |\n");
  lprint("\t    |             Serial Number: ________________            |\n");
  lprint("\t    |                                                        |\n");
  lprint("\t    +--------------------------------------------------------+\n");
  lputchar('\f');			/* Print FormFeed */
 }

void mailing()				/* Print Mailing List Application */
 {
  int x;				/* Temporary Variable */
  char t1[80];				/* Temporary String */
  char t2[80];				/* Temporary String */
  newline();				/* Advance the Line Counter */
  text(PRINT);				/* Have User Ready Printer */
  waitkey();				/* Wait for a Key */
  strcen("C Spot Run v" VERSION ,t1,78);/* Center String */
  strcen("Mailing List Application",t2,78); /* Center String */
  lprintf("\n\n %s\n %s\n\n\n",t1,t2);	/* Print Header */
  lprintf("\t\t\t\t\t\t\t\t%02d/%02d/%2d\n",mn,dy,yr);	/* Print Date */
  lprintf("\t%s, ",name);		/* Print User's Name */
  lprintf("%s\n",title);		/* Print User's Title */
  lprintf("\t%s\n",company);		/* Print User's Company */
  lprintf("\t%s\n",address);		/* Print User's Address */
  lprintf("\t%s, %s  %s\n",city,state,zip); /* Print User's City/State/ZIP */
  lprintf("\t%s\n\n",phone);		/* Print User's Phone */
  lprintf("\t%s - %s\n",compiler,drive);/* Print User's Configuration */
  lprintf("\n\n\n\n");			/* Space Out Form */
  lprint("                  -------  Fold Outward on this Line  -------\n");
  if ( ts )				/* If User Took Survey */
   {
    lprint("\n    -- Survey Results\n");	/* Print Survey Header */
    for ( x = 0; x < MAXSUR; ++x )	/* Loop Through Survey */
     {
      lprintf("    %d> %s\n",x+1,survques[x]);	/* Print Survey Question */
      lprintf("         %s\n",sr[x]);		/* Print Survey Result */
     }
    lprint("\n");
   }
  else					/* Otherwise */
    for ( x = 0; x < MAXSUR+2 ; ++x )	/* Loop for Survey Lines */
	lprint("\n\n"); 		/* Print a Newline */
  lprint("                  -------  Fold Outward on this Line  -------\n\n\n");
  lprint("\t\t\t\t\t\t\t\t\tPlace\n");
  lprint("\t\t\t\t\t\t\t\t\tStamp\n");
  lprint("\t\t\t\t\t\t\t\t\tHere.\n\n\n\n\n\n");
  lprint("\t\t\t\tNew Dimension Software\n");
  lprint("\t\t\t\tMailing List Application\n");
  lprint("\t\t\t\t23 Pawtucket Dr.\n");
  lprint("\t\t\t\tCherry Hill, NJ  08003\n");
  lputchar('\f');			/* Print FormFeed */
 }
