INCLUDE CLIBC_16.INC

;strcmp() -- Compare strings
;int __near strcmp(const char __near * const, char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ss
;   p_str2	near pointer, offset from ds
; RETURNS:
;   <0	if str1 < str2
;   0	if str1 = str2 (identical)
;   >0	if str1 > str2

_TEXT SEGMENT
strcmp PROC NEAR16 C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax

	    mov di,[p_str1]	    ;es:di = destination
	    mov si,[p_str2]	    ;ds:si = source

@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    je @F
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@:
            test al,al              ;Loop while not zero
	    jnz @@loop
	    ; str1 = str2
	    xor ax, ax		    ; equal strings
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
strcmp ENDP

; __fastcall
;   bx	    p_str1
;   ax	    p_str2
;int __fastcall __near strcmp(const char __near * const, char __near * const);
@strcmp PROC NEAR16 USES es si di bx cx dx

	    mov di, bx	    ;es:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ss
	    mov es, ax


@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    je @F
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@:
            test al,al              ;Loop while not zero
	    jnz @@loop
	    ; str1 = str2
	    xor ax, ax		    ; equal strings
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@strcmp ENDP
_TEXT ENDS
END
