INCLUDE CLIBC_16.INC

;memcmp() -- Compare memory blocks
;int __near memcmp(const void __near * const, const void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ds
;   p_m2	near pointer, (source) offset from ds
;   cnt 	number of characters to compare
;RETURNS: (int)
;   <0		m1 < m2
;   0		m1 = m2
;   >0		m1 > m2

_TEXT SEGMENT
memcmp	    PROC NEAR16 C uses es si di,
		p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, cnt:WORD

	    mov ax, ds
	    mov es, ax

	    mov di, [p_m1]	    ;es/ss:di = p_m1
	    mov si, [p_m2]	    ;ds:si = p_m2

	    xor ax, ax
	    mov cx, es
	    mov bx, ds
	    cmp cx, bx
	    jne @@cont
            cmp si,di               ;Equal?
	    je @@done
@@cont:
	    xor ax, ax	; assume equal
	    mov cx,[cnt]	   ;CX = count
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    je @@done

	    ; check last byte
	    dec si
	    dec di
	    lods BYTE PTR ds:[si]
	    mov ah, es:[di]
	    inc di
	    cmp ah, al	 ; m1, m2
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@done
@@less:
	    xor ax, ax
	    dec ax
@@done:
	    ret
memcmp ENDP

; __fastcall
;   bx	    p_m1, (source) offset from ds
;   ax	    p_m2, (dest) offset from ds
;   dx	    cnt
;int __fastcall __near memcmp(const void __near * const, const void __near * const, const int);
@memcmp PROC NEAR16 USES es si di bx cx dx

	    mov di, bx	    ;es/ss:di = p_m1
	    mov si, ax	    ;ds:si = p_m2
			    ;dx = cnt
	    mov cx, ds
	    mov es, cx
	    xor ax, ax
	    mov bx, ds
	    cmp cx, bx
	    jne @@cont
            cmp si,di               ;Equal?
	    je @@done
@@cont:
;	    xor ax, ax	; assume equal
	    mov cx, dx	   ;CX = count
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    je @@done

	    ; check last byte
	    dec si
	    dec di
	    lods BYTE PTR ds:[si]
	    mov ah, es:[di]
	    inc di
	    cmp ah, al	 ; m1, m2
	    jb @@less
	    xor ax, ax
	    inc ax ; 1
	    jmp @@done
@@less:
	    xor ax, ax
	    dec ax ; -1
@@done:
	    ret
@memcmp ENDP

;memcmp_sss() -- Compare memory blocks
;int __near memcmp_sss(const void __near * const, const void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ss
;   p_m2	near pointer, (source) offset from ds
;   cnt 	number of characters to compare
;RETURNS: (int)
;   <0		m1 < m2
;   0		m1 = m2
;   >0		m1 > m2
memcmp_sss PROC NEAR16 C uses es si di,
		p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, cnt:WORD

	    mov ax, ss
	    mov es, ax

	    mov di, [p_m1]	    ;es/ss:di = p_m1
	    mov si, [p_m2]	    ;ds:si = p_m2

	    xor ax, ax
	    mov cx, es
	    mov bx, ds
	    cmp cx, bx
	    jne @@cont
            cmp si,di               ;Equal?
	    je @@done
@@cont:
	    xor ax, ax	; assume equal
	    mov cx,[cnt]	   ;CX = count
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    je @@done

	    ; check last byte
	    dec si
	    dec di
	    lods BYTE PTR ds:[si]
	    mov ah, es:[di]
	    inc di
	    cmp ah, al	 ; m1, m2
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@done
@@less:
	    xor ax, ax
	    dec ax
@@done:
	    ret
memcmp_sss ENDP

; __fastcall
;   bx	    p_m1, (source) offset from ss
;   ax	    p_m2, (dest) offset from ds
;   dx	    cnt
;int __fastcall __near memcmp_sss(const void __near * const, const void __near * const, const int);
@memcmp_sss PROC NEAR16 USES es si di bx cx dx

	    mov di, bx	    ;es/ss:di = p_m1
	    mov si, ax	    ;ds:si = p_m2
			    ;dx = cnt
	    mov cx, ss
	    mov es, cx
	    xor ax, ax
	    mov bx, ds
	    cmp cx, bx
	    jne @@cont
            cmp si,di               ;Equal?
	    je @@done
@@cont:
;	    xor ax, ax	; assume equal
	    mov cx, dx	   ;CX = count
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    je @@done

	    ; check last byte
	    dec si
	    dec di
	    lods BYTE PTR ds:[si]
	    mov ah, es:[di]
	    inc di
	    cmp ah, al	 ; m1, m2
	    jb @@less
	    xor ax, ax
	    inc ax ; 1
	    jmp @@done
@@less:
	    xor ax, ax
	    dec ax ; -1
@@done:
	    ret
@memcmp_sss ENDP
_TEXT ENDS
END
