INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_skipspr:FN_CALL PTR
p_fn_fc_skipspr LABEL FN_CALL PTR
	P_FN_CALL @skipspr
	P_FN_CALL @skipspr_sss
_DATA ENDS

 ENDIF
ENDIF

; skipspr
; char __near * fn_call skipspr(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds
;		to the last non white space character in the string
;		if no more non white space characters in the string,
;		   then points to terminating '\0'
; NOTES:
; see isspace for the definition of a white space character

CLIBC_16_CS SEGMENT
skipspr PROC FN_CALL C USES es di, p_str:NEAR16 PTR BYTE
    mov ax, ds
    mov es, ax

    mov di, [p_str] ; es:di = p_str

    xor ax, ax	; zero out ax
    mov cx, ax
    dec cx	; cx = -1
    mov dx, cx	; dx = -1

    ; strlen(p_str)
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    ; cx = strlen(p_str)
    dec di
    dec di
    mov bx, di
@@luup:
    jcxz @@allspaces
    dec cx
    mov al, BYTE PTR es:[di]
    dec di
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@nonspace
    cmp al, 0Dh
    jle @@luup
@@nonspace:
    jmp @@done
@@allspaces:	; or null, so use bx
    mov di, bx
@@done:
    inc di
    mov ax, di
    ret
skipspr ENDP

; __fastcall
;   bx	    p_str, (source) offset from ds
; char __near * __fastcall fn_call skipspr(const char __near * const);
@skipspr PROC FN_CALL USES es di dx cx bx
    mov ax, ds
    mov es, ax

    mov di, bx ; es:di = p_str

    xor ax, ax	; zero out ax
    mov cx, ax
    dec cx	; cx = -1
    mov dx, cx	; dx = -1

    ; strlen(p_str)
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    ; cx = strlen(p_str)
    dec di
    dec di
    mov bx, di
@@luup:
    jcxz @@allspaces
    dec cx
    mov al, BYTE PTR es:[di]
    dec di
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@nonspace
    cmp al, 0Dh
    jle @@luup
@@nonspace:
    jmp @@done
@@allspaces:	; or null, so use bx
    mov di, bx
@@done:
    inc di
    mov ax, di
    ret
@skipspr ENDP

; skipspr_sss
; char __near * fn_call skipspr_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer, offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss
;		to the last non white space character in the string
;		if no more non white space characters in the string,
;		   then points to terminating '\0'
; NOTES:
; see isspace for the definition of a white space character

skipspr_sss PROC FN_CALL C USES es di, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov es, ax

    mov di, [p_str] ; es:di = p_str

    xor ax, ax	; zero out ax
    mov cx, ax
    dec cx	; cx = -1
    mov dx, cx	; dx = -1

    ; strlen(p_str)
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    ; cx = strlen(p_str)
    dec di
    dec di
    mov bx, di
@@luup:
    jcxz @@allspaces
    dec cx
    mov al, BYTE PTR es:[di]
    dec di
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@nonspace
    cmp al, 0Dh
    jle @@luup
@@nonspace:
    jmp @@done
@@allspaces:	; or null, so use bx
    mov di, bx
@@done:
    inc di
    mov ax, di
    ret
skipspr_sss ENDP

; __fastcall
;   bx	    p_str, offset from ss
; char __near * __fastcall fn_call skipspr_sss(const char __near * const);
@skipspr_sss PROC FN_CALL USES es di dx cx bx
    mov ax, ss
    mov es, ax

    mov di, bx ; es/ss:di = p_str

    xor ax, ax	; zero out ax
    mov cx, ax
    dec cx	; cx = -1
    mov dx, cx	; dx = -1

    ; strlen(p_str)
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    ; cx = strlen(p_str)
    dec di
    dec di
    mov bx, di
@@luup:
    jcxz @@allspaces
    dec cx
    mov al, BYTE PTR es:[di]
    dec di
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@nonspace
    cmp al, 0Dh
    jle @@luup
@@nonspace:
    jmp @@done
@@allspaces:	; or null, so use bx
    mov di, bx
@@done:
    inc di
    mov ax, di
    ret
@skipspr_sss ENDP
CLIBC_16_CS ENDS
END
