; isascii
;   AAA=mis
;   BBB=003
;   F=
;   O=0
; str003.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_isascii:FN_CALL PTR
p_fn_isascii P_FN_CALL isascii
EXTERNDEF C p_fn_fc_isascii:FN_CALL PTR
p_fn_fc_isascii P_FN_CALL @isascii
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; isascii
;int __fastcall fn_call isascii(const int);
; GIVEN:
;   num     number to determine
; RETURNS:
;   0	    is not ascii
;   1	    is ascii
; NOTES:
;   check both the high order byte and low order byte of num
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
isascii PROC FN_CALL C, num:WORD
    mov bx, num
    xor ax, ax
    test bh, bh
    jnz @@exit
    inc ax
@@exit:
    ret
isascii ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; isascii
; __fastcall
;int __fastcall fn_call isascii(const int);
; GIVEN:
;   AX	   number to determine
; RETUNS:
;   AX
;   0	    is not ascii
;   1	    is ascii
; NOTES:
;   check both the high order byte and low order byte of num
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@isascii PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax
    test bh, bh
    jnz @@exit
    inc ax
@@exit:
    ret
@isascii ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
