/****************************************************************
*	MOUSE3.C -- Demonstration program for third mouse article 	 *
*																					 *
*	To compile:	cl mouse3.c /link graphics								 *
****************************************************************/

#include <conio.h>		/* getch()										*/
#include <dos.h>			/* int86(), REGS								*/
#include <graph.h>		/* _clearscreen(), _GCLEARSCREEN()		*/
#include <stdio.h>		/* printf()										*/
#include <stdlib.h>		/* exit(), EXIT_FAILURE						*/
#include <string.h>		/* memset(), strset()						*/

void main(void)
	{
    char scr_string[41];
    int i, top, bottom, left, right, row, col, number_times;
    union REGS in_regs, out_regs;

    in_regs.x.ax = 0;           /* Initialize mouse */
    int86(0x33, &in_regs, &out_regs);
    if (!out_regs.x.ax)
    	{
        printf("Mouse could not be initialized.\n");
        exit(EXIT_FAILURE);
	    }

    _clearscreen(_GCLEARSCREEN);

    in_regs.x.ax = 1;           /* Show mouse cursor */
    int86(0x33, &in_regs, &out_regs);

	/* Draw a box on the screen */
	memset(scr_string,205,40);
    scr_string[0] = 201;
    scr_string[39] = 187;
    scr_string[40] = 0;
    printf("%s\n", scr_string);

    strset(scr_string, 32);
    scr_string[0] = 186;
    scr_string[39] = 186;
    for (i = 0; i < 10; i++)
        printf("%s\n", scr_string);

    strset(scr_string, 205);
    scr_string[0] = 200;
    scr_string[39] = 188;
    printf("%s\n\n\n", scr_string);

    printf("\nPress a key to restrict mouse cursor to the box.");
    getch();

    right = 39;         /* Restrict cursor horizontally */
    left = 2;
    in_regs.x.cx = 8 * (right - 1);
    in_regs.x.dx = 8 * (left - 1);
    in_regs.x.ax = 7;
    int86(0x33, &in_regs, &out_regs);

    top = 2;            /* Restrict cursor vertically */
    bottom = 11;
    in_regs.x.cx = 8 * (top - 1);
    in_regs.x.dx = 8 * (bottom - 1);
    in_regs.x.ax = 8;
    int86(0x33, &in_regs, &out_regs);

    in_regs.x.bx = 0;   /* Clear left button queue */
    in_regs.x.ax = 5;
    int86(0x33, &in_regs, &out_regs);
    printf(	"\nPress the left mouse button a few times,"
    		" then any key.");
    getch();

    in_regs.x.bx = 0;   /* Read left button queue */
    in_regs.x.ax = 5;
    int86(0x33, &in_regs, &out_regs);

    number_times = out_regs.x.bx;
    row = out_regs.x.dx / 8 + 1;
    col = out_regs.x.cx / 8 + 1;
    printf("\nYou pressed it %d times.", number_times);
    printf("\nLast time at (%d, %d).", row, col);

    in_regs.x.ax = 2;   /* Hide mouse cursor */
    int86(0x33, &in_regs, &out_regs);
	}
