/*************************************************************************
** interpcom-1.1 (command interpreter)                                   **
** interp.c : mini-interpreter						 **
**	      Commands interpreter and functions related to the          **
**	      Expression Evaluator                                       **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#define _VERSION_INTERP
#include "interp.h"

#define isnum(c)  (c >= '0' && c <= '9')

int 	  	    i_chlev = 0;
char		    h_ligne[300];          /* Ligne de commande        */
char	 	   *argv_c[20];            /* arguments de la ligne de 
					      commande                 */
char                cmdx[200];
int		    argc_c;                /* nombre d'arguments de la
                                              ligne de commande        */
                                           
long		    I;			   /* utilise pour calculer le
                                              temps d'execution d'une
                                              commande                 */
extern		    char *version;
extern		    char *esp_decalage;




/*-----------------------------------------------------------------------
    Initialisation de l'interpreteur de commandes. Cette fonction doit 
    etre appelee par main(). Elle comporte un appel a init_prog(), qui
    doit etre ecrite par l'utilisateur pour effectuer les initialisations
    necessaires a son programme. Elle se termine par un appel a 
    lect_com(), qui commence la lecture des commandes.
-----------------------------------------------------------------------*/
void
prog_c(int argc, char *argv[], char *int_ini, char int_ini_c[], int nb_ini)
{
    int	  	    i;

/*-------------------------------------------------------------------
    Initialisations 
-------------------------------------------------------------------*/
#ifdef _MSDOS_VERSION
    init_unixfic();
#endif
    nb_com = 0;        /* Nombre de commandes en memoire    */
    nb_mode_fonc = -1; /* Nombre de modes de fonctionnement */
    i_speed = 0;
    i_time_x = 0;
    Mon_File = NULL;

    __nbargmax = 10; 
    ind_com = 0; 
    pr_com = 0;
    ix_com = 0;   
    i_init_interp = 0;  
    i_greet = -1;   
    ind_x_mode = 0;
    ind_x_func = 0;
    ind_x_param = 0;
    ind_x_rep = 0;

    charge_com(int_ini, int_ini_c, nb_ini);              /* 
				 * lecture du fichier de configuration
                                 */
    if (ind_x_mode == 0 || ind_x_func == 0 || ind_x_param == 0 || 
        ind_x_rep == 0)
	exit_interp(NULL);
    ind_com = 1;
    i_com_cur = -1;

    traite_label();             /*
                                 * traitement des 'goto', 'if', 'do'
                                 * des programmes
                                 */
    curvoice = 0;               /* voix 0 = stdin */  
    inp[0] = stdin;
    prlevel = 0; 
    i_com = -1;
    ind_run = 0;  
    if (argc > 1) {
	inp[0] = fopen(argv[1], "r");
        if (inp[0] == NULL)
	    exit(0);
        prlevel = 1;
        ind_run = 1;
    }

    is_com = 0;  

    init_prog();		/*
				 * initialisations du programme
                                 * principal	
    			 	 */
    if (prlevel <= 0) {
        printf("\n");
        printf("%s\n", version);
    }
    if (i_init_interp != 0 && argc_init_interp > 0) {
        if (sil_init_interp == 0) 
	    prlevel++;
	shell_c(argc_init_interp, argv_init_interp);
        if (sil_init_interp == 0)
	    prlevel--;
    }
/*------------------------------------------------------------------*/


/*----------------------------------------------
    Affichage du message de debut d'execution
----------------------------------------------*/
    if (i_init_interp == 0) {
        for (i = 0; i < i_greet; i++)
             if (prlevel <= 0)
	         printf("%s\n", greet[i]);
    }

    lect_com();      /* lecture des commandes */
}
/*---------------------------------------------------------------------*/





/*-----------------------------------------------------------------------
    Fonction lisant et executant les commandes. C'est
    une boucle perpetuelle, appellee par prog_c().
-----------------------------------------------------------------------*/
void
lect_com(void)
{
    int		    i,
		    j;
    char	   *c;

        if (prlevel <= 0) 
            print("%s", prompt_mode[mode_fonct_]);   
		    /* Affichage du prompt, mode_fonct_ = numero du
                       mode de fonctionnement */ 
                                                   

/*-----------------------------------------------------------------
    lecture de la ligne de commande de la 'voix' numero curvoice.
    la voix 0 est stdin, les autres sont les fichiers de commandes
    appeles successivement.
-----------------------------------------------------------------*/
xxx:  while (fgets(h_ligne, 299, inp[curvoice]) != NULL) {
        if (curvoice == 0 && Mon_File != NULL)
	    fprintf(Mon_File, "%s", h_ligne);
        if (h_ligne[0] == '!') {    /* Detection d'une demande
				       d'execution d'une commande precedente */
	    c = h_ligne + 1;
            nettoie(c);
	    i = convert_int(c) + 1;
            if (i >= 0 && i <= ix_com && i > ix_com - __n_com_prec) {
		i = i_com - ix_com + i;
                if (i < 0)
		    i += abs(i) * __n_com_prec;
                i = i - (i / __n_com_prec) * __n_com_prec;
		memset(h_ligne, 0, 300);
		for (j = 0; j < strlen(com_prec[i]); j++)
                    h_ligne[j] = com_prec[i][j];
                h_ligne[strlen(com_prec[i])] = '\n';
                if (prlevel <= 0) {
		    print("%s", h_ligne);
                }
            }
	}
	extrait_arg();             /* extraction des arguments de 
                                      la ligne de commande       */
        if (curvoice == 0)
	    ix_com++;
	if (argv_c[0] == NULL) {
	    if (prlevel <= 0 && curvoice == 0) {
		if (pr_com == 0)
                    print("%s", prompt_mode[mode_fonct_]);
		else
		    print("%d %s", ix_com, prompt_mode[mode_fonct_]);
	    }
            continue;
        }

        i_com++;                  /* sauvegarde de la commande et 
				     actualisation de la liste des
				     commandes precedentes */
        if (i_com == __n_com_prec)
	    i_com = 0;
        if (com_prec[i_com] != NULL)
	    free(com_prec[i_com]);
	com_prec[i_com] = ch_copy(h_ligne);

        if (argv_c[0][0] == '[') {
	    i_speed = 1;
            argc_c = 0;
        }
        if (argv_c[0][0] == ']') {
	    i_speed = 0;
            argc_c = 0;
        }

        if (argc_c > 0) {
	    if (argv_c[0][0] != ';') {  /* si le premier argument
                                      commence par ';' c'est une 
				      ligne de commentaire et 
 				      on ne fait rien            */

                substit();         /* substitution des #1,..
                                      dans les arguments         */

                                   /* Affichage des arguments si
                                      cela est permis et si la 
				      commande provient d'un 
                                      fichier de commandes       */ 
                if (curvoice > 0 && prlevel <= 0) {
	            for (i = 0; i < argc_c; i++) {
	   	        print("%s ", argv_c[i]);
                    }

                    print("\n");
                }

                substit2();

                if (change_lev() == 0) /* detection et execution 
                                          d'un changement de voix 
				          (execution d'un nouveau fichier
                                          de commandes  */
                        shell_c(argc_c, argv_c);  /* execution de la
                                      commande                   */

                if (prlevel <= 0) {
		    if (pr_com == 0)
                        print("%s", prompt_mode[mode_fonct_]);
		    else 
			print("%d %s", ix_com, prompt_mode[mode_fonct_]);
		}
                memset(h_ligne, 0, 300);
	    }
            else
	        if (prlevel <= 0 && curvoice == 0) {
		    if (pr_com == 0)
                        print("%s", prompt_mode[mode_fonct_]);
		    else
			print("%d %s", ix_com, prompt_mode[mode_fonct_]);
		}
        }
        else
	    if (prlevel <= 0 && curvoice == 0)  {
		if (pr_com == 0)
                    print("%s", prompt_mode[mode_fonct_]);
		else
		    print("%d %s", ix_com, prompt_mode[mode_fonct_]);
	    }
    }

/*--------------------------------------
    Si on arrive a la fin d'un fichier 
    de commandes, on le ferme et on 
    revient au precedent
--------------------------------------*/
    if (curvoice > 0) {
 	fclose(inp[curvoice]);
	curvoice--;
	goto xxx;
    }
}
/*---------------------------------------------------------------------*/





/*-----------------------------------------------------------------------
    Extraction des arguments de la ligne de commande contenue dans 
    'h_ligne'. On determine le nombre d'arguments 'argc_c' et ceux-ci 
    sont places dans 'argv_c'.
-----------------------------------------------------------------------*/
void 
extrait_arg(void)
{
    int		    i,
		    ind,
		    j,
		    argn;
    char	    argtemp[300];

    nettoie(h_ligne);
    argn = -1;
    i = 0;
    ind = 0;
    j = 0;

    while (h_ligne[i] != 0) {
	if (h_ligne[i] != ' ') {
            ind = 1;
	    argn++;
            j = 0;
            argtemp[j] = h_ligne[i++];

            while (h_ligne[i] != ' ' && h_ligne[i] != 0) {
                argtemp[++j] = h_ligne[i++];
	    }
        }
	i++;
        if (ind == 1) {
	    if (argv_c[argn] != NULL)
		free(argv_c[argn]);
            argv_c[argn] = malloc((size_t) (j + 2) * sizeof(char));
            memcpy(argv_c[argn], argtemp, j + 1);
            argv_c[argn][j + 1] = 0;
            memset(argtemp, 0, 300);
        }
        ind = 0;
    }

    argc_c = argn + 1;
}
/*---------------------------------------------------------------------*/





/*-----------------------------------------------------------------------
    Detection et execution d'un changement de voix
-----------------------------------------------------------------------*/
int
change_lev(void)
{
    int		    i,
		    j;
    char	    h[300];

    if (argv_c[0] != NULL) {
	if (argv_c[0][0] == '<') {   /* Si le premier caractere du
                                        premier argument de la 
                                        commande est '<', on ouvre
                                        le fichier de commandes dont
                                        le nom suit                */

	    if (curvoice == __maxvoice - 1)
		return 0;
            curvoice++;

/*------------------------------------- Determination du nom du
                                        fichier de commandes et 
                                        ouverture                 */
            j = 0;
	    while (command_rep[j] != 0) {
		h[j] = command_rep[j];
                j++;
            }
            i = 1;
            while (argv_c[0][i] != 0) {
		h[j++] = argv_c[0][i++];
            }
            for (i = j; i < 300; i++)
		h[i] = 0;
            inp[curvoice] = fopen(h, "r");
            if (inp[curvoice] == NULL) {
                err_mess(20);
                argc_x[--curvoice] = 0;
                return 2;
            }
/*----------------------------------------------------------------*/


/*------------------------------------- Conservation des 
                                        autres arguments pour 
                                        servir de parametres a 
                                        l'interieur du fichier de
                                        commandes                 */
            for (i = 1; i < argc_x[curvoice - 1]; i++) 
		free(argv_x[curvoice - 1][i]);
            argc_x[curvoice - 1] = argc_c;
            for (i = 1; i < argc_c; i++) {
	        argv_x[curvoice - 1][i] = malloc((size_t) strlen(argv_c[i]));
                strcpy(argv_x[curvoice - 1][i], argv_c[i]);
	    }
 	}
        else
	    return 0;
    }
    return 1;
}
/*---------------------------------------------------------------------*/





/*-----------------------------------------------------------------------
    Substitution des #1,#2,#(expr.) dans les arguments de la ligne de 
    commande. Ils sont remplaces par les arguments de la ligne de 
    commande correspondante ayant lance le fichier de commandes en cours.
-----------------------------------------------------------------------*/
void
substit(void)
{
    int		    i,
		    ind,
		    j,
		    k,
		    l,
		    len,
		    nb,
		    n_com;
    float	    xb;
    char 	    h[200],
		    h1[300],
		    c;

    for (i = 1; i < argc_c; i++) {
        k = -1;
	j = 0;
        len = strlen(argv_c[i]);
        ind = 0;
        memset(h, 0, 200);

	while(j < len) { 
	    if ((argv_c[i][j] != '#' && argv_c[i][j] != '!' &&
                argv_c[i][j] != '%' && argv_c[i][j] != '$') ||
		(argv_c[i][j] == '#' && curvoice == 0)) {		    
		h[++k] = argv_c[i][j++];
	    }
	    else {
                if (argv_c[i][j] == '#' && curvoice != 0) {
		    ind = 1;
                    j++;
                    l = -1;
                    memset(h1, 0, 300);
                    n_com = 0;
		    if (j < len) {
		        if (argv_c[i][j] == '(') {
			    while (j < len && argv_c[i][j] != ')') {
			        h1[++l] = argv_c[i][j++];
		            }

                            n_com = convert_int(h1);
                            j++;
                        }
                        else {
		            while (isnum(argv_c[i][j])) {
		                h1[++l] = argv_c[i][j++];
		            }
                            if (l >= 0) 
                                n_com = convert_int(h1);
		        }
                    }
		    if (n_com <= 0 || n_com > (argc_x[curvoice - 1] - 1)) {
		        free(argv_c[i]);
                        argv_c[i] = malloc((size_t) 1 * sizeof(char));
                        argv_c[i][0] = 0;
                        ind = 0;
                        break;
                    }
                    else {
		        strcat(h, argv_x[curvoice - 1][n_com]);
                        k += strlen(argv_x[curvoice - 1][n_com]);
                    }
	        }
                else {
                    if (argv_c[i][j] == '$') {
                        c = argv_c[i][j++];
		        ind = 1;
                        if (j < len) {
		            if (argv_c[i][j] == '(')
			        j++;
		            if (j < len) {
                                nb = -1;
                                memset(h1, 0, 300);
                                l = -1;

			        while(j < len && argv_c[i][j] != ')') {
                                    h1[++l] = argv_c[i][j++];
			        }
			
			        if (l >= 0) 
                                    nb = convert_int(h1);
                                memset(h1, 0, 300);
                                if (nb >= 0 && nb <= __max_quest)
			            strcpy(h1, ques[nb]);
                                strcat(h, h1);
                                j++;
                                k += strlen(h1);
		            }
		            else
			        break;
		        }
		        else
		            break;
                   }
                    else {
                        c = argv_c[i][j++];
		        ind = 1;
                        if (j < len) {
		            if (argv_c[i][j] == '(')
			        j++;
		            if (j < len) {
                                nb = 0;
                                xb = 0.;
                                memset(h1, 0, 300);
                                l = -1;

			        while(j < len && argv_c[i][j] != ')') {
                                    h1[++l] = argv_c[i][j++];
			        }
			
			        if (l >= 0) {
                                    if (c == '!')
                                        nb = convert_int(h1);
                                    else
				        xb = convert_float(h1);
                                }
                                memset(h1, 0, 300);
                                if (c == '!')
			            sprintf(h1, "%d", nb);
                                else
				    sprintf(h1, "%f", xb);
                                strcat(h, h1);
                                j++;
                                k += strlen(h1);
		            }
		            else
			        break;
		        }
		        else
		            break;
		    }
		}
            }
	}

        if (ind == 1) {
	    free(argv_c[i]);
	    argv_c[i] = malloc((size_t) (k + 2) * sizeof(char));
            strcpy(argv_c[i], h);
            argv_c[i][k + 1] = 0;
	}
    }	
}
/*---------------------------------------------------------------------*/




/*-----------------------------------------------------------------------
    Substitution des '#' aux '{'
-----------------------------------------------------------------------*/
void 
substit2(void)
{
    int		    i,
		    j;

    for (i = 1; i < argc_c; i++) {
	j = 0;

        while (argv_c[i][j] != 0) {
	    if (argv_c[i][j] == '{')
		argv_c[i][j] = '#';
	    j++;
        }
    }
}
/*---------------------------------------------------------------------*/




/*-----------------------------------------------------------------------
    Execution d'une commande. Son nom et ses arguments se trouvent dans 
    'argv', le nombre total d'arguments (y compris le nom de la commande) 
    est 'argc'.
-----------------------------------------------------------------------*/
void
shell_c(int argc, char *argv[])
{
    int		    i,
		    j,
                    i_comb,
		    i_cond;
    double	    x;
    
    if (prlevel <= 0)
	time(&I);	   /* I contient le temps du debut 
                              d'execution de la commande         */

    if (i_speed == 0) {
        i = lookup_c(names, argv[0], len_n, nb_commandes);  
			   /* i contient le numero de la commande
                              appelee si son nom est 
			      reconnu, -1 sinon                  */

/*----------------------------------------
    gestion des conditions (voir
    commandes 'si', 'is' ('si_cmd' 
    et 'is_cmd' dans command.c)
----------------------------------------*/
        i_cond = -1;
        if (n_cond >= 0) {
            for (j = 0; j <= n_cond; j++) {
	        if (s_cond[j] == 1 && convert_float(v_cond[j]) <= 0)
		    i_cond = 0;
                if (s_cond[j] == -1 && convert_float(v_cond[j]) > 0)
	   	    i_cond = 0;
            }
        }
/*--------------------------------------*/


        if (i_cond < 0 || comp("is", argv[0]) == 1) {

/*-----------------------
     Execution de la commande
    (s'il y a lieu)
-----------------------*/
  	    if (i >= 0) {
                if (mode_com[i][mode_fonct_] == 1) {   
			/* on teste si la commande est executable dans le
                           mode de fonctionnement courant            */ 
                    if (test_param(argc, i) == 1)
	                (*(proc[i])) (argc, argv);  /* execution */
                    else 
		        err_mess(0);
                }
	        else
		    err_mess(25);
            }
/*--------------------*/


            else {
/*----------------------
    On detecte s'il s'agit d'un
    programme et en ce
    cas on l'execute
----------------------*/
                i = lookup_b(argv[0]);
                if (i >= 0) {
                     i_comb = i_com_cur;
                     execute(i, argc, argv); 
	             i_com_cur = i_comb;
		}
/*--------------------*/
         

	        else {
/*----------------------
    Si la commande n'est pas
    reconnue du tout elle est
    evaluee comme expression numerique
----------------------*/
	            memset(cmdx, 0, 200);
	            for (j = 0; j < argc; j++) 
		        strcat(cmdx, argv[j]);
	            x = convert_float(cmdx);
                    if (prlevel <= 0 && is_com == 0) {
		        print("%s%f\n", esp_decalage, (float) x);
                    }
	        }
	    }
        }
        prTime();
    }
    else {
        memset(cmdx, 0, 200);
        for (j = 0; j < argc; j++) 
            strcat(cmdx, argv[j]);
        convert_float(cmdx);
    }	
}
/*---------------------------------------------------------------------*/





/*-----------------------------------------------------------------------
    Fonction retournant l'entier i si 's' est le debut du nom
    de la commande i, et si c'est la premiere commande
    (pour l'ordre lexicographique) a avoir cette propriete.
-----------------------------------------------------------------------*/
int
lookup_c(char *names[], char *s, int *len, int nb)
{ 
    int		    i,
		    i0;

    i0 = (int) s[0];
    if (fin_nom[i0] == -1)
	return -1;
    for (i = deb_nom[i0]; i <= fin_nom[i0]; i++)
	if (comp(names[i], s) == 1)
	    return i;

    return -1;   
}
/*---------------------------------------------------------------------*/




/*----------------------------------------------------------------------
    Routine d'affichage du temps pris par l'execution d'une commande.
----------------------------------------------------------------------*/
void
prTime(void)
{
    long 	    J;
    int 	    i,
		    k,
		    h;

    if (horloge == 1) {
        time(&J);
        i = J - I;
        if (i >= 2) {
            k = i / 60;
            h = k / 60;
            i -= 60 * k;
            k -= 60 * h;

            if (h != 0 && prlevel <= 0) {
#ifdef _ENG_LANG
		print(" ; execution time : %d h  %d mn  %d s\n", 
		    h, k, i);
#else
                print(" ; temps d'execution : %d h  %d mn  %d s\n", 
		    h, k, i);
#endif
                return;
            }
            if (k != 0 && prlevel <= 0) {
#ifdef _ENG_LANG
                print(" ; execution time : %d mn  %d s\n", k, i);
#else
                print(" ; temps d'execution : %d mn  %d s\n", k, i);
#endif
                return;
            }
            if (i != 0 && prlevel <=0) {
#ifdef _ENG_LANG
                print(" ; execution time : %d s\n", i);
#else
                print(" ; temps d'execution : %d s\n", i);
#endif
            }
        }
    }
}
/*---------------------------------------------------------------------*/





int Evaluate(char *, double *, int *);   /*  cf. ee.c */
char		hlec[100];



/*----------------------------------------------------------------------
    Conversion d'une expression en entier. 
    Par exemple si 'arg' contient 'x+y' , ou x et y sont des variables 
    deja definies, cette fonction retourne la valeur de x+y. Si 'arg'
    contient 'x=2', cette fonction retourne 2, et assigne 2 a la 
    variable x, la definissant si elle n'est pas deja definie.
----------------------------------------------------------------------*/
int 
convert_int(char *arg)
{
      return (int)floor(convert_float(arg));
}
/*--------------------------------------------------------------------*/





/*----------------------------------------------------------------------
    Conversion d'une expression en entier (2)
    Sert essentiellement a definir des variables cachees (c'est-a-dire
    non accessibles par le clavier) ou a recuperer ce qu'elles 
    contiennent. Par exemple, si 'arg' contient 'x=2', cette fonction
    donne la valeur 2 a la variable x, la definissant si elle n'est pas
    deja definie, la valeur retournee est alors 2. Si 'arg' contient
    'x', cette fonction retourne la valeur de la variable cachee x.
----------------------------------------------------------------------*/
int
S_convert_int(char *arg)
{
    int		    i;
    char 	    h[100];

    memset(h, 0, 100);
    h[0] = 127;
    for (i = 0; i < (int) strlen(arg); i++)
	h[i + 1] = arg[i];
    return convert_int(h);
}
/*--------------------------------------------------------------------*/




/*----------------------------------------------------------------------
    Conversion d'une expression en reel flottant
    Par exemple si 'arg' contient 'x*sin(y)' , ou x et y sont des 
    variables deja definies, cette fonction retourne la valeur de 
    x*sin(y). Si 'arg' contient 'x=2', cette fonction retourne 2, 
    et assigne 2 a la variable x, la definissant si elle n'est pas deja
    definie.
----------------------------------------------------------------------*/
double
convert_float(char *arg)
{
    double 	    res;
    int 	    dum;
    
    if (Evaluate(arg, &res, &dum) == E_OK) 
	return res;
    return 0.0;
}
/*--------------------------------------------------------------------*/





/*----------------------------------------------------------------------
    Conversion d'une expression en entier (2)
    Sert essentiellement a definir des variables cachees (c'est-a-dire
    non accessibles par le clavier) ou a recuperer ce qu'elles 
    contiennent. Par exemple, si 'arg' contient 'x=2', cette fonction
    donne la valeur 2 a la variable x, la definissant si elle n'est pas
    deja definie, la valeur retournee est alors 2. Si 'arg' contient
    'x', cette fonction retourne la valeur de la variable cachee x.
----------------------------------------------------------------------*/
double
S_convert_float(char *arg)
{
    int		    i;
    char 	    h[100];

    memset(h, 0, 100);
    h[0] = 127;
    for (i = 0; i < (int) strlen(arg); i++)
	h[i + 1] = arg[i];
    return convert_float(h);
}
/*-------------------------------------------------------------------*/





/*---------------------------------------------------------------------
    Commande d'evaluation d'une expression
    Syntaxe :
	eval <expression>
---------------------------------------------------------------------*/
int
eval_cmd(int argc, char *argv[])
{
    double 	    x;
    int		    i;
    char	    h[100],
		    k[300];

    if (argc < 2) {
	err_mess(0);
	return 0;
	}
    memset(h, 0, 100);
    memset(k, 0, 300);
    for (i = 1; i < argc; i++)
	strcat(k, argv[i]);
    x = convert_float(k);
    sprintf(h, "curvar=%f", (float)x);
    convert_float(h);
    if (prlevel <= 0) {
	print("                      %f\n", x);
    }
    return 0;
}
/*--------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Fonctions testant si un caractere est "alpha-numerique"
---------------------------------------------------------------------*/
int 
is_alphab(char s)
{
    if ((s >= 'A' && s <= 'Z') || (s >= 'a' && s <= 'z') || s == '_')
	return 1;
    else
	return 0;
}

int 
is_alphab_or_num(char s)
{    
    if (is_alphab(s) == 1 || (s >= '0' && s <= '9')) 
	return 1;
    else
	return 0;
}
/*--------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction de lecture d'un parametre reel flottant (comme 'scanf'
    mais marche meme a l'interieur d'un fichier de commandes ou d'un
    programme).
---------------------------------------------------------------------*/
void
read_float(float *x)
{
    memset(hlec, 0, 100);
    if (i_com_cur == -1) {
        fgets(hlec, 99, inp[curvoice]);
        nettoie(hlec);
    }
    else {
	if (i_ligne_cur < nb_lignes[i_com_cur]) {
	    i_ligne_cur++;
            i_lec_cur++;
	    strcpy(hlec, ligne_com[i_com_cur][i_ligne_cur]);
	}
    }
    x[0] = convert_float(hlec);
    if (prlevel <= 0) {
        if (Mon_File != NULL)
 	    fprintf(Mon_File, "%f\n", x[0]);
        if (i_com_cur != -1)
	    print("%f\n", x[0]);
    }
}
/*--------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction de lecture d'un parametre entier (comme 'scanf'
    mais marche meme a l'interieur d'un fichier de commandes ou
    d'un programme).
---------------------------------------------------------------------*/
void
read_int(int *n)
{
    memset(hlec, 0, 100);
    if (i_com_cur == -1) {
        fgets(hlec, 99, inp[curvoice]);
        nettoie(hlec);
    }
    else {
	if (i_ligne_cur < nb_lignes[i_com_cur]) {
	    i_ligne_cur++;
            i_lec_cur++;
	    strcpy(hlec, ligne_com[i_com_cur][i_ligne_cur]);
	}
    }
    n[0] = convert_float(hlec);
    if (prlevel <= 0) {
   	if (Mon_File != NULL)
 	    fprintf(Mon_File, "%d\n", n[0]);
        if (i_com_cur != -1)
	    print("%d\n", n[0]);
    }
}
/*--------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction de lecture d'une chaine de caracteres (comme 'scanf'
    mais marche meme a l'interieur d'un fichier de commandes ou d'un
    programme).
---------------------------------------------------------------------*/
void
read_char(char *st)
{
    memset(hlec, 0, 100);
    if (i_com_cur == -1) {
        fgets(hlec, 99, inp[curvoice]);
        nettoie(hlec);
    }
    else {
	if (i_ligne_cur < nb_lignes[i_com_cur]) {
	    i_ligne_cur++;
            i_lec_cur++;
	    strcpy(hlec, ligne_com[i_com_cur][i_ligne_cur]);
	}
    }
    strcpy(st, hlec);
    if (prlevel <= 0) {
   	if (Mon_File != NULL)
 	    fprintf(Mon_File, "%s\n", hlec);
        if (i_com_cur != -1)
	    print("%s\n", hlec);
    }
}
/*--------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction interpretant une expression du type
    <nom>[<expression>], renvoie la valeur entiere de <expression>
    dans 'nb' et <nom> dans 'nm'. Utilisee dans objdef.c 
    (fonction 'obj_create') pour interpreter une commande du type
	defobjet f0[5]
    Les objets f0[1], f0[2], f0[3], f0[4], f0[5] sont alors definis.
---------------------------------------------------------------------*/
int
parse_def(char *ent, int *nb, char *nm)
{
    int 	    i,
		    j,
		    slen,
		    ind,
		    re;
    char	    nbx[50];

    memset(nbx, 0, 50);
    i = 0;
    j = -1;
    ind = 0;
    re = 0;
    slen = (int) strlen(ent);

    while (i < slen) {
 	if (ind == 0) {
	    if (ent[i] == ']')
		return 0;
	    if (ent[i] == '[')
	 	ind = 1;
	    else
		nm[i] = ent[i];
	}
	else {
            if (ent[i] == ']') {
		if (i != slen - 1)
		    return 0;
	    }
	    else {
	        if (i == slen)	
		    return 0;
  		j++;
	        if (j >= 50)
		    return 0;
	        nbx[j] = ent[i];
	    } 
	}   
	i++;
    }

    if (ind == 0)
	return 2;
    nb[0] = convert_int(nbx);
    if (nb[0] <= 0)
	return 0;
    return 1;
} 
/*--------------------------------------------------------------------*/
