/*************************************************************************
** interpcom-1.1 (command interpreter - tutorial)                        **
** main.c : An application of the command interpreter                    **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#include "interp.h"
#include "funct.h"
int    _nbfunc;

int
main(int argc, char *argv[])
{
    prog_c(argc, argv, "funct.ini", NULL, 0);
    return 0;
}

void
init_prog()
{
    _nbfunc = S_convert_int("nb_funct");
}

void
exit_prog()
{
    exit(0);
}
 
void
dest_prop(int typ, int i0)
{
    int		    i;
    char	  **c;
    funct_f	   *a_f;
    funct_d	   *a_d;
    funct_C	   *a_C;
    funct_dC	   *a_dC;
    float	   *xr;
    double	   *xrd;
    char	   *k[2];

    if (typ > _XRANGE_F && typ < _CFUNC_D)
	detruit_funct(typ + 1, i0);
    if (typ == _FOUR_TR - 1)
	detruit_four_prec(typ + 1, i0);

    if (typ == _XRANGE_F - 1) {  /* when we destroy a x-range we must also
                                    destroy all the functions that use it  */
	xr = (float *) Obj[_XRANGE_F - 1][i0].adresse;
        k[0] = ch_copy("destroy");

	for (i = 0; i < _nbfunc; i++) {
	    if (Obj[_RFUNC_F - 1][i].occup == 1) {
		c = (char **) Obj[_RFUNC_F - 1][i].adresse;
		a_f = (funct_f *) c[0];
                if (a_f->x == xr) {
		    k[1] = ch_copy(Obj[_RFUNC_F - 1][i].nom_obj);
                    detruit_obj(2, k);
                    free(k[1]);
		}
	    }
	}

	for (i = 0; i < _nbfunc; i++) {
	    if (Obj[_CFUNC_F - 1][i].occup == 1) {
		c = (char **) Obj[_CFUNC_F - 1][i].adresse;
		a_C = (funct_C *) c[0];
                if (a_C->x == xr) {
		    k[1] = ch_copy(Obj[_CFUNC_F - 1][i].nom_obj);
                    detruit_obj(2, k);
                    free(k[1]);
		}
	    }
	}
        free(k[0]);
    }
    if (typ == _XRANGE_D - 1) {  /* when we destroy a x-range we must also
                                    destroy all the functions that use it  */
	for (i = 0; i < _nbfunc; i++) {
	xrd = (double *) Obj[_XRANGE_D - 1][i0].adresse;
        k[0] = ch_copy("destroy");

	for (i = 0; i < _nbfunc; i++) {
	    if (Obj[_RFUNC_D - 1][i].occup == 1) {
		c = (char **) Obj[_RFUNC_D - 1][i].adresse;
		a_d = (funct_d *) c[0];
                if (a_d->x == xrd) {
		    k[1] = ch_copy(Obj[_RFUNC_D - 1][i].nom_obj);
                    detruit_obj(2, k);
                    free(k[1]);
		}
	    }
	}

	for (i = 0; i < _nbfunc; i++) {
	    if (Obj[_CFUNC_D - 1][i].occup == 1) {
		c = (char **) Obj[_CFUNC_D - 1][i].adresse;
		a_dC = (funct_dC *) c[0];
                if (a_dC->x == xrd) {
		    k[1] = ch_copy(Obj[_CFUNC_D - 1][i].nom_obj);
                    detruit_obj(2, k);
                    free(k[1]);
		}
	    }
	}
        free(k[0]);
	}
    }
}
