/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>

/* write an elementary type (int,short,char) where size <= 4 */
int jio_write_elementary_type(FILE *fp,void *type,size_t size)
{
  JLIB_ENTER("jio_write_elementary_type");

#ifndef JLIB_PRODUCTION
  if((fp == NULL) || (type == NULL)) {
     jlib_exit(jlib_msg(JLIB_ENULL));
  }
#endif

  switch(size){
 
     case 1:{
         UBYTE c = *(UBYTE *)type;

         fputc(c,fp);
         
         if(ferror(fp)){
            jlib_exit(jlib_msg(JLIB_EFILE));
         }
         
         break;
     }
   
     case 2:{
         USHORT c = *((USHORT *)type);

         fputc((UBYTE)(c & 0xff),fp);

         fputc((UBYTE)((c >> 8) & 0xff),fp);
         
         if(ferror(fp)){
            jlib_exit(jlib_msg(JLIB_EFILE));
         }

         break;
     }

     case 4:{
         ULONG c = *((ULONG*)type);

         fputc((UBYTE)(c & 0xff),fp);

         fputc((UBYTE)((c >> 8)  & 0xff),fp);
        
         fputc((UBYTE)((c >> 16) & 0xff),fp);

         fputc((UBYTE)((c >> 24)  & 0xff),fp);
         
         if(ferror(fp)){
            jlib_exit(jlib_msg(JLIB_EFILE));
         }

         break;
     }
   
     default:
         /* anything other than 1,2, or 4 bytes to be written is an error */
         jlib_exit(jlib_msg(JLIB_EFILE));
  }

  JLIB_LEAVE;
  return 1;
}



/* read an elementary type (int,short,char) where size <= 4 */
int jio_read_elementary_type(FILE *fp,void *type,size_t size)
{
 int i;

  JLIB_ENTER("jio_read_elementary_type");

#ifndef JLIB_PRODUCTION
  if((fp == NULL) || (type == NULL)) {
     jlib_exit(jlib_msg(JLIB_ENULL));
  }
#endif

  switch(size){
 
     case 1:{
         i=fgetc(fp);
         
         if(ferror(fp)){
            jlib_exit(jlib_msg(JLIB_EFILE));
         }

         *(UBYTE *)type = (UBYTE)(i & 0xff);
         
	break;
     }
   
     case 2:{
         i=fgetc(fp);
         i |= (fgetc(fp) << 8);
         
         if(ferror(fp)){
            jlib_exit(jlib_msg(JLIB_EFILE));
         }

         *((USHORT *)type) = (USHORT)(i & 0xffff);
         break;
     }

     case 4:{
         i = fgetc(fp);
         i |= (fgetc(fp) << 8);
         i |= (fgetc(fp) << 16);
         i |= (fgetc(fp) << 24);

         if(ferror(fp)){
            jlib_exit(jlib_msg(JLIB_EFILE));
         }
                  
         *((ULONG*)type) = (ULONG)i;

         break;
     }
   
     default:
         /* anything other than 1,2, or 4 bytes to be read is an error */
         jlib_exit(jlib_msg(JLIB_EFILE));    
  }
  
  JLIB_LEAVE;
  return 1;
}


