/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <jlib.h>
#include <vga.h>

extern vga_modeinfo *__jlib_modeinfo;

/*+------------------------------------------------------------------------+ */
/*|blit a fullscreen buffer to the screen                                  | */
/*+------------------------------------------------------------------------+ */
JINLINE void screen_blit_fs_buffer (buffer_rec * buff)
{
 UBYTE *out=B_BUFF_PTR(buff);
 int i;

 for(i=0;i<__jlib_pages;i++){

    vga_setpage(i);
  
    LONG_COPY(out, vga_getgraphmem(), 65536);
    out+=65536;
 }
}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen without clipping.                   | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_toNC (int x, int y, buffer_rec * sbuff,
			 int sbx1, int sby1, int sbx2, int sby2)
{
   int v_len = sby2 - sby1+1, h_len = sbx2 - sbx1+1;
   UBYTE *src = B_BUFF_PTR (sbuff) + (B_X_SIZE (sbuff) * sby1) + sbx1;
   UBYTE *dest = vga_getgraphmem ();
   int width = B_X_SIZE (sbuff);
   int offset,page;
 
   offset=y*__jlib_modeinfo->linewidth+x;
   page=offset>>16;
   offset&=0xffff;
   vga_setpage(page);   
     
   for (; v_len != 0; v_len--){
        
		if (offset + h_len > 0x10000)
			if (offset >= 0x10000) {
				page++;
				vga_setpage(page);
				offset &= 0xffff;
			}
			else {	/* page break within line */
				memcpy(dest+offset, src, 0x10000 - offset);
				page++;
				vga_setpage(page);
				memcpy(dest,src+ 0x10000 - offset,
					(offset + h_len) & 0xffff);
				offset = (offset + __jlib_modeinfo->linewidth) & 0xffff;
				src += width;
				continue;
			}
		memcpy(vga_getgraphmem()+ offset, src, h_len);
		src+=width;
		offset += __jlib_modeinfo->linewidth;
    }

}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen with clipping.                      | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_to (int x, int y, buffer_rec * sbuff,
			  int sbx1, int sby1, int sbx2, int sby2)
{

   int v_len,h_len;
   UBYTE *src;
   UBYTE *dest = vga_getgraphmem();
   int width,height;
   int offset,page;

   width = B_MAX_X(sbuff);
   height = B_MAX_Y(sbuff);
   src = B_BUFF_PTR(sbuff);

   if (sbx1 > sbx2){
        JLIB_SWAP (sbx1, sbx2);
   }

   if (sby1 > sby2){
        JLIB_SWAP (sby1, sby2);
   }

   /* clip src buffer */
   if((sbx1>width) ||(sby1>height) || (sbx2<0) || (sby2<0)){
      return;
   }

   if(sbx1<0){
      sbx1=0;
   }
   if(sby1<0){
      sby1=0;
   }
   if(sbx2>width){
      sbx2=width;
   }
   if(sby2>height){
      sby2=height;
   }

   if ((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y)){
	return;
   }

   if(x<0){
      sbx1-=x;
      x=0;
      if(sbx1>sbx2){
         return;
      }
   }
   if(y<0){
      sby1-=y;
      y=0;
      if(sby1>sby2){
         return;
      }
   }

   v_len = sby2 - sby1+1;
   h_len = sbx2 - sbx1+1;

   if ((x + h_len) > SCREEN_WIDTH){
	h_len = SCREEN_WIDTH - x;
   }

   if ((y + v_len) > SCREEN_HEIGHT){
	v_len = SCREEN_HEIGHT - y;
   }

   width++; /* from max x to buffer width */
   src += (B_X_SIZE(sbuff) * sby1) + sbx1;

   offset=y*__jlib_modeinfo->linewidth+x;
   page=offset>>16;
   offset&=0xffff;
   vga_setpage(page);   
     
   for (; v_len != 0; v_len--){
        
		if (offset + h_len > 0x10000)
			if (offset >= 0x10000) {
				page++;
				vga_setpage(page);
				offset &= 0xffff;
			}
			else {	/* page break within line */
				memcpy(dest+offset, src, 0x10000 - offset);
				page++;
				vga_setpage(page);
				memcpy(dest,src+ 0x10000 - offset,
					(offset + h_len) & 0xffff);
				offset = (offset + __jlib_modeinfo->linewidth) & 0xffff;
				src += width;
				continue;
			}
		memcpy(vga_getgraphmem()+ offset, src, h_len);
		src+=width;
		offset += __jlib_modeinfo->linewidth;
    }

}


