/*
 * Change attributes of files
 *
 * Options:
 *		+/-A	= ADD/REMOVE Archive bit
 *		+/-H	= ADD/REMOVE Hidden bit
 *		+/-R	= ADD/REMOVE Readonly bit
 *		+/-S	= ADD/REMOVE System bit
 *	Examples:
 *		chattr \dos\*.* +r
 *		chattr \temp\*.* -a
 *		chattr c:\command.com +h +r
 *
 * Copyright 1990-1994 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc chattr -fop
 */
#include <stdio.h>
#include <file.h>

	int or_mask = 0, and_mask = 0x0027;

	int fcount = 0;
	char *fnames[20];

	char attributes[] = { 'R', 'H', 'S', 'V', 'D', 'A' };

/*
 * Main program - set file attributes
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j;
	char chr, chr1, *ptr, *ptr1, path[65];

	char name[14];
	int sizeh, sizel, attrs, time, date;

	/* Evaluate filenames & attributes to set/clear */
	chr1 = 0;
	for(i=1; i < argc; ++i) {
		chr = argv[i][0];
		if((chr == '+') || (chr == '-')) {
			for(j=0; (chr1 = attributes[j]) != toupper(argv[i][1]); ++j) {
				if(!chr1)
					abort("Invalid attribute\n"); }
			j = 1 << j;
			if(chr == '+')
				or_mask |= j;
			else
				and_mask &= ~j; }
		else
			fnames[fcount++] = argv[i]; }

	if(!(fcount && chr1))
		abort("\nUse: chattr <filespec*>... +/-AHRS\n\nCopyright 1990-1994 Dave Dunfield\nAll rights reserved.\n");

	/* Step through file list, setting attributes of files */
	for(i = 0; i < fcount; ++i) {
		if(find_first(ptr = ptr1 = fnames[i], -1, name, &sizeh, &sizel, &attrs, &time, &date)) {
			fputs(ptr, stderr);
			fputs(": Not found\n", stderr);
			continue; }
		/* Determine directory path */
		while(chr = *ptr++)
			if((chr == '\\') || (chr == ':'))
				ptr1 = ptr;
		*ptr1 = 0;
		do {
			concat(path, fnames[i], name);	/* Create full pathname */
			if(set_attr(path, (attrs & and_mask) | or_mask)) {
				fputs(path, stderr);
				fputs(": Unable to set attributes\n", stderr); } }
		while(!find_next(name, &sizeh, &sizel, &attrs, &time, &date)); }
}
