/*
 * PC COUNTDOWN
 *
 * A simple "count down" timer with large numeric display.
 *
 * Copyright 1994 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc pcs -fop
 */
#include <stdio.h>
#include <window.h>

#define	YOFFSET	3		/* Offset to display numbers from top of screen */

/* Font table for numeric character display */
char numfont[10][7] = {
	0x1C,	/* 00011100 */
	0x22,	/* 00100010 */
	0x45,	/* 01000101 */
	0x49,	/* 01001001 */
	0x51,	/* 01010001 */
	0x22,	/* 00100010 */
	0x1C,	/* 00011100 */

	0x08,	/* 00001000 */
	0x18,	/* 00011000 */
	0x38,	/* 00111000 */
	0x08,	/* 00001000 */
	0x08,	/* 00001000 */
	0x08,	/* 00001000 */
	0x3E,	/* 00111110 */

	0x1C,	/* 00011100 */
	0x22,	/* 00100010 */
	0x02,	/* 00000010 */
	0x0C,	/* 00001100 */
	0x10,	/* 00010000 */
	0x20,	/* 00100000 */
	0x3E,	/* 00111110 */

	0x1C,	/* 00011100 */
	0x22,	/* 00100010 */
	0x02,	/* 00000010 */
	0x1C,	/* 00011100 */
	0x02,	/* 00000010 */
	0x22,	/* 00100010 */
	0x1C,	/* 00011100 */

	0x04,	/* 00000100 */
	0x0C,	/* 00001100 */
	0x14,	/* 00010100 */
	0x24,	/* 00100100 */
	0x7E,	/* 01111110 */
	0x04,	/* 00000100 */
	0x04,	/* 00000100 */

	0x3E,	/* 00111110 */
	0x20,	/* 00100000 */
	0x3C,	/* 00111100 */
	0x22,	/* 00100010 */
	0x02,	/* 00000010 */
	0x22,	/* 00100010 */
	0x1C,	/* 00011100 */

	0x1C,	/* 00011100 */
	0x22,	/* 00100010 */
	0x20,	/* 00100000 */
	0x3C,	/* 00111100 */
	0x22,	/* 00100010 */
	0x22,	/* 00100010 */
	0x1C,	/* 00011100 */

	0x3E,	/* 00111110 */
	0x02,	/* 00000010 */
	0x04,	/* 00000100 */
	0x08,	/* 00001000 */
	0x10,	/* 00010000 */
	0x20,	/* 00100000 */
	0x20,	/* 00100000 */

	0x1C,	/* 00011100 */
	0x22,	/* 00100010 */
	0x22,	/* 00100010 */
	0x1C,	/* 00011100 */
	0x22,	/* 00100010 */
	0x22,	/* 00100010 */
	0x1C,	/* 00011100 */

	0x1C,	/* 00011100 */
	0x22,	/* 00100010 */
	0x22,	/* 00100010 */
	0x1E,	/* 00011110 */
	0x02,	/* 00000010 */
	0x04,	/* 00000100 */
	0x18 }	/* 00011000 */

/* Text for key prompt box */
char keyprompt[] = {
"Up/Down    - Adjust seconds\n\
PgUp/PgDn  - Adjust 10's seconds\n\
Home/End   - Adjust minites\n\
Space      - Start/Stop\n\
Escape     - Exit" };

int mattrs[3] = {		/* Monochrome attributes */
	WSAVE|WCOPEN|WBOX2|NORMAL,
	WCOPEN|WBOX1|REVERSE,
	WSAVE|WBOX2|NORMAL };

int cattrs[3] = {		/* Color attributes */
	WSAVE|WCOPEN|WBOX2|0x12,
	WCOPEN|WBOX1|0x43,
	WSAVE|WBOX2|0x17 };

int *attrs;				/* Pointer to current attributes */

main()
{
	int i;
	static int seconds = 0;

	wopen(0, 0, 1, 1, 0);
	wclose();
	attrs = (W_BASE == 0xB000) ? mattrs : cattrs;

	wopen(0, 0, 80, 25, attrs[0]);
	wgotoxy(6, 22);
	putstr("PC COUNTDOWN - Copyright 1994 Dave Dunfield - All rights reserved.");
	wcursor_off();
	wgotoxy(38, YOFFSET+2); wputc(0xFE);
	wgotoxy(38, YOFFSET+4); wputc(0xFE);

	wopen(20, 14, 40, 7, attrs[1]);
	putstr(keyprompt);
	wclose();

	W_OPEN->WINattr = attrs[2];

	for(;;) {
		if(seconds < 0)
			seconds = 0;
		else if(seconds > ((99*60)+59))
			seconds = (99 * 60) + 59;
		display_number(seconds);
		switch(wgetc()) {
			case _KUA :
				++seconds;
				continue;
			case _KDA :
				--seconds;
				continue;
			case _KPU :
				seconds += 10;
				continue;
			case _KPD :
				seconds -= 10;
				continue;
			case _KHO :
				seconds += 60;
				continue;
			case _KEN :
				seconds -= 60;
				continue;
			case ' ' :
				i = seconds;
				while(i && (wtstc() != ' ')) {
					delay(1000);
					display_number(--i); }
				if(i)
					continue;
				for(i=0; i < 10; ++i) {
					wputc(7);
					delay(100); }
				continue;
			case 0x1B :
				wclose();
				return; } }
}

/*
 * Draw a number on the screen
 */
display_number(t)
	unsigned t;
{
	unsigned s, m;

	m = t / 60;
	s = t % 60;

	draw_digit(m / 10, 19);
	draw_digit(m % 10, 28);
	draw_digit(s / 10, 40);
	draw_digit(s % 10, 49);
}

/*
 * Draw a single digit on the screen
 */
draw_digit(i, col)
	unsigned i, col;
{
	int j, k;
	char c;

	for(j=0; j < 7; ++j) {
		wgotoxy(col, j+YOFFSET);
		c = numfont[i][j];
		for(k=0; k < 8; ++k) {
			wputc((c & 0x80) ? i+'0' : ' ');
			c <<= 1; } }
}

/*
 * Write a string to the screen
 */
putstr(ptr)
	char *ptr;
{
	while(*ptr)
		wputc(*ptr++);
}
