/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
gjA(int n)
{
int      i;
int      j;
int      k;
int      x;
fraction f;

double pbA  [n][n*TWOCOL];       matrix mA   ={n,n*TWOCOL,&pbA         [0][0]};
double pbb  [n][n*TWOCOL];       matrix mb   ={n,n*TWOCOL,&pbb         [0][0]};
double pbID [n][n*TWOCOL];       matrix mID  ={n,n*TWOCOL,&pbID        [0][0]};
double pA_ID[n][n*TWOCOL*TWOCOL];matrix mA_ID={n,n*TWOCOL*TWOCOL,&pA_ID[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x =  20;}

  randmF(&mA,x,5);

  copymAID (&mA,&mID,&mA_ID);

  clrscrn();
  printf("                               The augmented matrix is  :");
  printmA_IDbF(&mA_ID);
  getchar();

  clrscrn();
  printf("\n     Reducing this to reduced row-echelon form yields :\n");
  gaussjordanF(&mA_ID);
  printmA_IDbF(&mA_ID);
  getchar();

  printf("\n                      A x = b has the unique solution :\n");
  copyinv(&mA_ID,&mb);
  printmbF(      &mb);
  printf("\n\n                            Where b[n] are arbitrary \n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France \n");
  printf("\n                                                  ");
  printf("\n        Let A be a fixed m x n matrix             ");
  printf("\n      Find all m x 1 matrices b such that         ");
  printf("\n  the system of equation Ax = b is consistent   \n");
  printf("\n                                                  ");
  printf("\n The size of mA : 2x2     4x4                   \n");
  printf("\n           ex : \"syscgssf exe\"                \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"syscgssf exe 2\" -> mA 2x2      ");
  printf("\n                \"syscgssf exe 3\" -> mA 3x3      ");
  printf("\n                \"syscgssf exe 4\" -> mA 4x4      ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www simtel net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  gjA(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

