/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
detab(
int n)
{
fraction detA;
fraction detB;
fraction detAB;

double pbA [MXR][MXC*TWOCOL];matrix mA ={MXR,MXC*TWOCOL,&pbA [0][0]};
double pbB [MXR][MXC*TWOCOL];matrix mB ={MXR,MXC*TWOCOL,&pbB [0][0]};
double pbAB[MXR][MXC*TWOCOL];matrix mAB={MXR,MXC*TWOCOL,&pbAB[0][0]};

                   mA.rows=n;                   mA.cols=n*TWOCOL;
                   mB.rows=n;                   mB.cols=n*TWOCOL;
                  mAB.rows=n;                  mAB.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmI(&mA,5);
  rndmI(&mB,5);

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);

  detA = detF(&mA);
  printf("\n                                      det(A) = %.0f\n", detA.numer);

  detB = detF(&mB);
  printf("\n                                      det(B) = %.0f\n", detB.numer);

  detAB = multF(detA,detB);
  printf("\n det(A) * det(B) = (%.0f) * (%.0f) =  %.0f\n",
         detA.numer,         detB.numer,         detAB.numer );
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  multmF(&mA,&mB,&mAB);
  printf("                                                      AB :");
  printmI(&mAB);
  detAB = detF(&mAB);
  printf("\n                                   det(AB) = %.0f \n", detAB.numer);

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n              det(A) det(B) = det(AB)             ");
  printf("\n              ***********************             ");
  printf("\n                                                  ");
  printf("\n The size of mA : 1x1 ... 4x4.                  \n");
  printf("\n     ex : \"dabi.exe\"                          \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"dabi.exe 2 \" -> 2x2                  ");
  printf("\n          \"dabi.exe 3 \" -> 3x3                  ");
  printf("\n          \"dabi.exe 4 \" -> 4x4                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
   srand(time(&t));
   hello();
do
{

if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 1){n=1;}


  detab(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












