/* xxpid.h                      freeware                   xhunga@tiscali.fr  */

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :  gauss-jordan on a matrix with the identity matrix.                */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* See   :  mtrxic.zip,  gjid0 .c                                             */
/* -------------------------------------------------------------------------- */
void gjidF(
pmatrix m)
{
     int row1;
     int row2;
     int n;
fraction f;

double pbID [MXR][MXC*TWOCOL];matrix mID  ={MXR,MXC*TWOCOL,&pbID [0][0]};
double pbT  [MXR][MXC*TWOCOL];matrix mT   ={MXR,MXC*TWOCOL,&pbT  [0][0]};

 n = m->rows;
                    mID.rows = n;       mID.cols =  n   *TWOCOL;
                     mT.rows = n;        mT.cols = (n+1)*TWOCOL;
/*--------------------------------------------------------------------  gauss */
for (row1 = 0 ; row1 < m->rows-1 ; row1++)
{
 pivotntzeroF(m,row1, row1);
 gausspivotbestF(m,row1, row1);

 f.numer =  *(m->pblock+row1   *m->cols+row1*TWOCOL  );
 f.denom =  *(m->pblock+row1   *m->cols+row1*TWOCOL+1);

if(f.denom < 0 )                              /* Only the numerator is signed */
{
 f.numer = -1*(f.numer);
 f.denom = -1*(f.denom);
}
 clrscrn();

 printf("The matrix m\n\n");
 printmF4(m);
 printf("\n\n");
 printf(" The pivot value = %.0f/%.0f \n\n", f.numer, f.denom);

if(f.numer < 0 )                                  /* The inverse of the pivot */
{
 f.numer = -1*(f.numer);
 f.denom = -1*(f.denom);
}

 printf(" The inverse of the pivot value = %.0f/%.0f \n\n",f.denom, f.numer);
 getchar();

 clrscrn();

 mid(&mID);

 *(mID.pblock+row1 *mID.cols+row1*TWOCOL   ) = f.denom;
 *(mID.pblock+row1 *mID.cols+row1*TWOCOL+1 ) = f.numer;

 printf("\n If you multiply this identity matrix\n");
 printf(" (with the inverse of the pivot) :     \n");
 printmF4(&mID);
 getchar();

 clrscrn();
 printmF4(&mID);
 printf("\n By the matrix m :\n");
 printmF4(m);
 copymF(     m,  &mT);
 multmF(&mID, &mT, m );
 printf("\n The pivot = 1 \n");
 printmF4(m);
 getchar();

          mid(&mID);
          for (row2 = row1+1 ; row2 < m->rows ; row2++)
          {
              (*(mID.pblock+row2 *mID.cols+row1*TWOCOL)) = \
             -(*(m->pblock+row2  *m->cols+row1*TWOCOL));

               *(mID.pblock+row2 *mID.cols+row1*TWOCOL+1) = \
               *(m->pblock+row2  *m->cols+row1*TWOCOL+1);

          }
           clrscrn();
           printf("\n The matrix m \n");
           printmF4(m);
           printf("\n Copy all the value below the pivot \n");
           printf(" in the identity matrix. And take the opposite.\n");
           printmF4(&mID);
           getchar();

           clrscrn();
           printmF4(&mID);
           printf("\n Multiply this matrix by m :\n ");
           printmF4(m);
           copymF(     m,  &mT);
           multmF(&mID, &mT, m );
           printf("\n All the coefficients under the pivot = 0\n ");
           printmF4(m);
           getchar();
}



   row1 == m->rows-1;
  {
   f.numer =  *(m->pblock+row1   *m->cols+row1*TWOCOL  );
   f.denom =  *(m->pblock+row1   *m->cols+row1*TWOCOL+1);

   if(f.denom < 0 )                           /* Only the numerator is signed */
     {
      f.numer = -1*(f.numer);
      f.denom = -1*(f.denom);
      }

   clrscrn();
   printf("The matrix m\n\n");
   printmF4(m);
   printf("\n\n");
   printf(" The pivot value = %.0f/%.0f \n\n", f.numer, f.denom);

   if(f.numer < 0 )                               /* The inverse of the pivot */
     {
      f.numer = -1*(f.numer);
      f.denom = -1*(f.denom);
     }

    printf(" The inverse of the pivot value = %.0f/%.0f \n\n",f.denom, f.numer);
    getchar();

    mid(&mID);

    *(mID.pblock+row1 *mID.cols+row1*TWOCOL   ) = f.denom;
    *(mID.pblock+row1 *mID.cols+row1*TWOCOL+1 ) = f.numer;

    clrscrn();

    printf("\n If you multiply this identity matrix\n");
    printf(" (with the inverse of the pivot) :     \n");
    printmF4(&mID);
    getchar();

    clrscrn();

    printmF4(&mID);
    printf("\n By the matrix m :\n");
    printmF4(m);
    copymF(     m,  &mT);
    multmF(&mID, &mT, m );
    printf("\n The pivot = 1\n");
    printmF4(m);
    getchar();
   }



/*-------------------------------------------------------------------- jordan */
for (row1 = m->rows-1 ; row1>0 ; row1--)
{
    mid(&mID);
    for (row2 = 0 ; row2 < row1 ; row2++)
    {
     (*(mID.pblock+row2 *mID.cols+row1*TWOCOL)) = \
    -(*(m->pblock+row2   *m->cols+row1*TWOCOL));

      *(mID.pblock+row2 *mID.cols+row1*TWOCOL+1) = \
      *(m->pblock+row2  *m->cols+row1*TWOCOL+1);
     }
           clrscrn();
           printmF4(m);
           printf("\n Copy all the value above the pivot \n");
           printf(" in the identity matrix. And take the opposite.\n");
           printmF4(&mID);
           getchar();

           clrscrn();
           printmF4(&mID);
           printf("\n Multiply this matrix by m :\n");
           printmF4(m);
           copymF(     m,  &mT);
           multmF(&mID, &mT, m );
           printf("\n All the coefficients above the pivot = 0\n");
           printmF4(m);
           getchar();
}
  printf("\n Now, you have the solution \n");
}



/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :  Inverse a matrix with the identity matrix.                        */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* See   :  mtrxic.zip,  invid0 .c                                            */
/* -------------------------------------------------------------------------- */
void invidF(
pmatrix mA,
pmatrix mAID
)
{
     int row1;
     int row2;
     int n;
fraction f;

double pID  [MXR][MXC*TWOCOL];matrix mID  ={MXR,MXC*TWOCOL,&pID  [0][0]};
double pAIDT[MXR][MXC*TWOCOL];matrix mAIDT={MXR,MXC*TWOCOL,&pAIDT[0][0]};

 n = mA->rows;
                   mID.rows=n;                 mID.cols=n*TWOCOL;
                 mAIDT.rows=n;               mAIDT.cols=n*TWOCOL*TWOCOL;
/*--------------------------------------------------------------------  gauss */
copymAID (mA,mAID);

for (row1 = 0 ; row1 < mAID->rows-1 ; row1++)
{
 pivotntzeroF(mAID,row1, row1);

 f.numer =  *(mAID->pblock+row1   *mAID->cols+row1*TWOCOL    );
 f.denom =  *(mAID->pblock+row1   *mAID->cols+row1*TWOCOL+1);

if(f.denom < 0 )                              /* Only the numerator is signed */
{
 f.numer = -1*(f.numer);
 f.denom = -1*(f.denom);
}
 clrscrn();
 printf("The matrix mA mID\n\n");
 printmF2(mAID);
 printf("\n\n");
 printf(" The pivot value = %.0f/%.0f \n\n", f.numer, f.denom);

if(f.numer < 0 )                                  /* The inverse of the pivot */
{
 f.numer = -1*(f.numer);
 f.denom = -1*(f.denom);
}

 printf(" The inverse of the pivot value = %.0f/%.0f \n\n",f.denom, f.numer);
 getchar();

 mid(&mID);

 *(mID.pblock+row1 *mID.cols+row1*TWOCOL  ) = f.denom;
 *(mID.pblock+row1 *mID.cols+row1*TWOCOL+1) = f.numer;

 clrscrn();
 printf("\n If you multiply this identity matrix \n ");
 printf(" (with the inverse of the pivot) :    \n ");
 printmF2(&mID);
 getchar();

 clrscrn();
 printmF2(&mID);
 printf("\n By the matrix mA mID :\n ");
 printmF2(mAID);
 copymF(     mAID,   &mAIDT);
 multmF(&mID,   &mAIDT, mAID);
 printf("\n The pivot = 1\n");
 printmF2(mAID);
 getchar();

          mid(&mID);
          for (row2 = row1+1 ; row2 < mAID->rows ; row2++)
          {
              (*(mID.pblock+row2     *mID.cols+row1* TWOCOL)) = \
             -(*(mAID->pblock+row2   *mAID->cols+row1*TWOCOL));

               *(mID.pblock+row2   *mID.cols+row1*TWOCOL+1) = \
               *(mAID->pblock+row2 *mAID->cols+row1*TWOCOL+1);

          }
           clrscrn();
           printmF2(mAID);
           printf("\n Copy all the value below the pivot \n ");
           printf(" in the identity matrix. And take the opposite.\n ");
           printmF2(&mID);
           getchar();

           clrscrn();
           printmF2(&mID);
           printf("\n Multiply this matrix by mA mID :\n ");
           printmF2(mAID);
           copymF( mAID,&mAIDT);
           multmF(&mID, &mAIDT, mAID);
           printf("\n All the coefficients under the pivot = 0 \n ");
           printmF2(mAID);
           getchar();
}

   row1 == mAID->rows-1;
  {
   f.numer =  *(mAID->pblock+row1   *mAID->cols+row1*TWOCOL  );
   f.denom =  *(mAID->pblock+row1   *mAID->cols+row1*TWOCOL+1);

   if(f.denom < 0 )                           /* Only the numerator is signed */
     {
      f.numer = -1*(f.numer);
      f.denom = -1*(f.denom);
      }

   clrscrn();
   printf("The matrix mA mID\n\n");
   printmF2(mAID);
   printf("\n\n");
   printf(" The pivot value = %.0f/%.0f \n\n", f.numer, f.denom);

   if(f.numer < 0 )                               /* The inverse of the pivot */
     {
      f.numer = -1*(f.numer);
      f.denom = -1*(f.denom);
     }

    printf(" The inverse of the pivot value = %.0f/%.0f \n\n",f.denom, f.numer);
    getchar();

    mid(&mID);

    *(mID.pblock+row1 *mID.cols+row1*TWOCOL   ) = f.denom;
    *(mID.pblock+row1 *mID.cols+row1*TWOCOL+1 ) = f.numer;

    clrscrn();
    printf("\n If you multiply this identity matrix \n ");
    printf(" (with the inverse of the pivot) :    \n ");
    printmF2(&mID);
    getchar();

    clrscrn();
    printmF2(&mID);
    printf("\n By the matrix mA mID :\n ");
    printmF2(mAID);
    copymF(   mAID,   &mAIDT);
    multmF(&mID, &mAIDT, mAID);
    printf("\n The pivot = 1 \n");
    printmF2(mAID);
    getchar();
   }


/*-------------------------------------------------------------------- jordan */
for (row1 = mAID->rows-1 ; row1>0 ; row1--)
{
    mid(&mID);
    for (row2 = 0 ; row2 < row1 ; row2++)
    {
     (*(mID.pblock+row2   *mID.cols+row1*TWOCOL)) = \
    -(*(mAID->pblock+row2 *mAID->cols+row1*TWOCOL));

      *(mID.pblock+row2   *mID.cols+row1*TWOCOL+1) = \
      *(mAID->pblock+row2 *mAID->cols+row1*TWOCOL+1);
     }
           clrscrn();
           printmF2(mAID);
           printf("\n Copy all the value above the pivot \n ");
           printf(" in the identity matrix. And take the opposite.\n ");
           printmF2(&mID);
           getchar();

           clrscrn();
           printmF2(&mID);
           printf("\n Multiply this matrix by mA mID :\n ");
           printmF2(mAID);
           copymF(   mAID,   &mAIDT);
           multmF(&mID, &mAIDT, mAID);
           printf("\n All the coefficients above the pivot = 0\n ");
           printmF2(mAID);
           getchar();
}
clrscrn();
printmF2(mAID);
}


