/*
**  gets.c
**
**  Just like SIMPLE, except uses SioGets rather than SioGetc,
**  and SioPuts rather than SioPutc.
*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dos.h>
#include <string.h>
#include <conio.h>

#include "pcl4c.h"

#define FALSE 0
#define TRUE !FALSE
#define BSIZE 10

/*** Global Variables ***/

int Port = COM1;          /* Port COM1 */
int BaudCode;             /* baud rate code ( index into BaudRate[] ) */
char *BaudRate[10] =  {"0","300","1200","2400","4800","9600",
                       "19200","38400","57600","115200"};
//char *UartString[4] = {"8250/16450", "16550", "16650", "16750"};
char RxBuffer[128+16];
char TxBuffer[128+16];
char Buffer[BSIZE];
char *Alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n";
int  Longest = 0;

/* local prototypes */

int BaudMatch(char *);
int ErrorCheck(int);

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i, n, rc;
 char far *Ptr;
 int  Seg;
 int Version;
 if(argc!=3)
   {printf("Usage: GETS <port> <baud>\n");
    exit(1);
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<COM1) || (Port>COM20))
   {printf("Port must be COM1 to COM20n");
    exit(1);
   }
 /* get baud rate from command line */
 BaudCode = BaudMatch(argv[2]);
 if(BaudCode<0)
   {printf("Cannot recognize baud rate = %s\n",argv[2]);
    exit(1);
   }
 /* setup 128 byte receive buffer */
 Ptr = (char far *)RxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 SioRxBuf(Port,Seg,Size128);
 /* setup 128 byte transmit buffer */
 Ptr = (char far *)TxBuffer;
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 SioTxBuf(Port,Seg,Size128);
 /* set port parmameters */
 ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) );
 /* reset the port */
 ErrorCheck( SioReset(Port,BaudCode) );
 ErrorCheck( SioFIFO(Port,LEVEL_4TH) );
 /* set DTR and RTS */
 ErrorCheck( SioDTR(Port,'S') );
 ErrorCheck( SioRTS(Port,'S') );
 /* display library version */
 Version = SioInfo('V');
 printf("Lib Version %d.%d\n",Version>>4,0x0f&Version);
 printf("\nEnter terminal loop ( Type ^Z to exit )\n");
 /* enter terminal loop */
 while(TRUE)
   {if(SioBrkKey())
      {/* restore COM port status & exit */
       printf("BREAK\n");
       SioDone(Port);
       exit(2);
      }
    /* was key pressed ? */
    if(kbhit())
       {i = getch();
        if((char)i==0x1a)
           {/* user typed ^Z */
            printf("\nLongest=%d\n",Longest);
            printf("%d RX Interrupts, ", SioInfo('R') );
            printf("%d TX Interrupts\n", SioInfo('T') );
            /* restore COM port status & exit */
            SioDone(Port);
            exit(1);
           }
        if((char)i=='#') SioPuts(Port,Alpha,28);
        else SioPuts(Port,&(char)i,1);
       } /* end if */
    /* any incoming over serial port ? */
    n = SioGets(Port,Buffer,BSIZE);
    if(n>Longest) Longest = n;
    for(i=0;i<n;i++) putch(Buffer[i]);
   }
} /* end main */

int ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
    {printf("ERROR %d:",Code);
     SioError(Code);
     SioDone(Port);
     exit(1);
    }
 return(0);
} 


int BaudMatch(char *P)
{int i;
 /* find baud rate in table */
 for(i=0;i<10;i++) if(strcmp(BaudRate[i],P)==0) return(i);
 return(-1);
}
